// DDR2_burst_test_tb.v
`default_nettype none
`timescale 1ps / 1ps

module DDR2_burst_test_tb;

	`include "ddr2_parameters.vh"
	`include "./ddr2_cont_parameters.vh"

	wire [DQ_BITS-1:0] dq;
	wire [DQS_BITS-1:0] dqs;
	reg reset;
	wire [DQS_BITS-1:0] ddr2_dqs_fpga, ddr2_dqs_sdram;
	wire [DQS_BITS-1:0] ddr2_dqs_n_fpga, ddr2_dqs_n_sdram;
	wire [DQ_BITS-1:0] ddr2_dq_fpga, ddr2_dq_sdram;
	reg [DQS_BITS-1:0] ddr2_dqs_fpgan, ddr2_dqs_sdramn;
	reg [DQS_BITS-1:0] ddr2_dqs_n_fpgan, ddr2_dqs_n_sdramn;
	reg [DQ_BITS-1:0] ddr2_dq_fpgan, ddr2_dq_sdramn;
	wire ddr2_clk, ddr2_clkb;
	wire ddr2_cke, ddr2_csb, ddr2_rasb, ddr2_casb, ddr2_web;
	wire [DM_BITS-1:0] ddr2_dm;
	wire [1:0] ddr2_ba;
	wire [ADDR_BITS-1:0] ddr2_address;
	reg enable_o;
	reg clk;
	wire [2:0] cmd;
	reg sdram_clk;
	reg sdram_clkb;
	reg [12:0] sdram_address;
	reg [1:0] sdram_ba;
	reg sdram_cke;
	reg sdram_csb, sdram_rasb, sdram_casb, sdram_web;
	reg [1:0] sdram_dmn;
	wire [1:0] sdram_dm;
	wire [3:0] LED;
	reg sd_loop_in;
	wire sd_loop_out;
	
	parameter DELAY_TIME = 1500;
	parameter CLK_PERIOD = 20000;
	
	assign cmd = {ddr2_rasb, ddr2_casb, ddr2_web};
	
	always @(posedge ddr2_clk, posedge reset)
		if (reset)
			enable_o <= 1'b0;
		else
			if (cmd==3'b100)
				enable_o <= 1'b0;
			else if (cmd==3'b101)
				enable_o <= 1'b1;

	always @ *
		if (enable_o == 1'b1)
			ddr2_dqs_fpgan <= #DELAY_TIME ddr2_dqs_sdram;
		else
			ddr2_dqs_fpgan <= #DELAY_TIME {DQS_BITS{1'bz}};
	
	always @ *
		if (enable_o == 1'b1)
			ddr2_dqs_n_fpgan <= #DELAY_TIME ddr2_dqs_n_sdram;
		else
			ddr2_dqs_n_fpgan <= #DELAY_TIME {DQS_BITS{1'bz}};
	
	always @ *
		if (enable_o == 1'b1)
			ddr2_dq_fpgan <= #DELAY_TIME ddr2_dq_sdram;
		else
			ddr2_dq_fpgan <= #DELAY_TIME {DQ_BITS{1'bz}};

	always @ *
		if (enable_o == 1'b0)
			ddr2_dqs_sdramn <= #DELAY_TIME ddr2_dqs_fpga;
		else
			ddr2_dqs_sdramn <= #DELAY_TIME {DQS_BITS{1'bz}};
	
	always @ *
		if (enable_o == 1'b0)
			ddr2_dqs_n_sdramn <= #DELAY_TIME ddr2_dqs_n_fpga;
		else
			ddr2_dqs_n_sdramn <= #DELAY_TIME {DQS_BITS{1'bz}};
	
	always @ *
		if (enable_o == 1'b0)
			ddr2_dq_sdramn <= #DELAY_TIME ddr2_dq_fpga;
		else
			ddr2_dq_sdramn <= #DELAY_TIME {DQ_BITS{1'bz}};
	
	assign ddr2_dqs_fpga = ddr2_dqs_fpgan;
	assign ddr2_dqs_n_fpga = ddr2_dqs_n_fpgan;
	assign ddr2_dq_fpga = ddr2_dq_fpgan;
	assign ddr2_dqs_sdram = ddr2_dqs_sdramn;
	assign ddr2_dqs_n_sdram = ddr2_dqs_n_sdramn;
	assign ddr2_dq_sdram = ddr2_dq_sdramn;

	always @ * begin
		sdram_clk <= #DELAY_TIME ddr2_clk;
		sdram_clkb <= #DELAY_TIME ddr2_clkb;
		sdram_address <= #DELAY_TIME ddr2_address;
		sdram_ba <= #DELAY_TIME ddr2_ba;
		sdram_cke <= #DELAY_TIME ddr2_cke;
		sdram_csb <= #DELAY_TIME ddr2_csb;
		sdram_rasb <= #DELAY_TIME ddr2_rasb;
		sdram_casb <= #DELAY_TIME ddr2_casb;
		sdram_web <= #DELAY_TIME ddr2_web;
		sdram_dmn <= #DELAY_TIME ddr2_dm;
	end
	
	always @* begin // from sd_loop_in to sd_loop_out delay
		sd_loop_in <= #(DELAY_TIME*2) sd_loop_out;
	end
	
	DDR2_burst_test DDR2_burst_test_inst(
		.SYS_CLK(clk),
		.SYS_RST(reset),
		.LED(LED),
		
		.ddr2_clk(ddr2_clk),
		.ddr2_clkb(ddr2_clkb),
		.ddr2_cke(ddr2_cke),
		.ddr2_dqs(ddr2_dqs_fpga),
		.ddr2_dqs_n(ddr2_dqs_n_fpga),
		.ddr2_dq(ddr2_dq_fpga),
		.ddr2_csb(ddr2_csb),
		.ddr2_rasb(ddr2_rasb),
		.ddr2_casb(ddr2_casb),
		.ddr2_web(ddr2_web),
		.ddr2_dm(ddr2_dm),
		.ddr2_ba(ddr2_ba),
		.ddr2_address(ddr2_address),
		.sd_loop_in(sd_loop_in),
		.sd_loop_out(sd_loop_out)
	);
	
	assign sdram_dm = sdram_dmn;
	
	ddr2 MT47H16M16_inst(
		.dq(ddr2_dq_sdram),
		.dqs(ddr2_dqs_sdram),
		.dqs_n(ddr2_dqs_n_sdram),
		.rdqs_n(),
		.addr(sdram_address),
		.ba(sdram_ba),
		.ck(sdram_clk),
		.ck_n(sdram_clkb),
		.cke(sdram_cke),
		.cs_n(sdram_csb),
		.ras_n(sdram_rasb),
		.cas_n(sdram_casb),
		.we_n(sdram_web),
		.dm_rdqs(sdram_dm)
	);
	
	initial begin
			reset = 1'b0;
		#1000	reset = 1'b1;
		#200000	reset = 1'b0;
	end
	
	always begin
	   #(CLK_PERIOD/2)	clk = 1'b1 ;
	   #(CLK_PERIOD/2)	clk = 1'b0 ;
	end
	
	initial begin
		#50000000	$stop;
	end
endmodule
		
	