// wrdata_fifo
// ݃f[^Ă
// data 128bit + mask 16bit

// 2008/03/07 : Ver. 1.1 : wp, rpƉZ鐔̃rbg𐧌,@rbg̐ȂƓ-̉Z鎞ɕg32rbgōs邽߂fullo͂Ȃ

`default_nettype none
`timescale 1ns / 1ps

module wrdata_fifo (clk, reset, din, maskin, rd_en, wr_en, full, almost_full, empty, almost_empty, dout, maskout);
	`include "./ddr2_cont_parameters.vh"
	
	input clk;
	input reset;
	input [INTERFACE_DATA_WIDTH-1 : 0] din;
	input [INTERFACE_MASK_WIDTH-1 : 0] maskin;
	input rd_en;
	input wr_en;
	output full;
	output almost_full;
	output empty;
	output almost_empty;
	output [INTERFACE_DATA_WIDTH-1 : 0] dout;
	output [INTERFACE_MASK_WIDTH-1 : 0] maskout;
	
	wire clk;
	wire reset;
	wire [INTERFACE_DATA_WIDTH-1 : 0] din;
	wire [INTERFACE_MASK_WIDTH-1 : 0] maskin;
	wire rd_en;
	wire wr_en;
	wire full;
	wire almost_full;
	wire empty;
	wire almost_empty;
	wire [INTERFACE_DATA_WIDTH-1 : 0] dout;
	wire [INTERFACE_MASK_WIDTH-1 : 0] maskout;
	
	reg [3:0] wp, rp;
	wire [INTERFACE_DATA_WIDTH-1 : 0] data_node;
	reg [INTERFACE_DATA_WIDTH-1 : 0] out_data;
	wire [INTERFACE_MASK_WIDTH-1 : 0] mask_node;
	reg [INTERFACE_MASK_WIDTH-1 : 0] out_mask;
	reg outff_flag;
	wire fifo_full, fifo_empty;
	wire inner_rd_en;
	wire we ;
	wire wr_en_node;
	
	assign 
	// synthesis translate_off
			#1
	// synthesis translate_on
				wr_en_node =wr_en;
							
	generate
	genvar i;
		for (i=INTERFACE_DATA_WIDTH-1; i>=0; i=i-1) begin: WRDATA_RAM
			RAM16X1D #(
				.INIT(16'h0000) // Initial contents of RAM
			) RAM16_DATA (
				.DPO(data_node[i]),
				.SPO(),
				.A0(wp[0]),
				.A1(wp[1]),
				.A2(wp[2]),
				.A3(wp[3]),
				.D(din[i]),
				.DPRA0(rp[0]),
				.DPRA1(rp[1]),
				.DPRA2(rp[2]),
				.DPRA3(rp[3]),
				.WCLK(clk),
				.WE(we)
			);
		end
	endgenerate
	
	generate
	genvar j;
		for (j=INTERFACE_MASK_WIDTH-1; j>=0; j=j-1) begin: WRMASK_RAM
			RAM16X1D #(
				.INIT(16'h0000) // Initial contents of RAM
			) RAM16_MASK (
				.DPO(mask_node[j]),
				.SPO(),
				.A0(wp[0]),
				.A1(wp[1]),
				.A2(wp[2]),
				.A3(wp[3]),
				.D(maskin[j]),
				.DPRA0(rp[0]),
				.DPRA1(rp[1]),
				.DPRA2(rp[2]),
				.DPRA3(rp[3]),
				.WCLK(clk),
				.WE(we)
			);
		end
	endgenerate
	assign we = wr_en_node && (~fifo_full);
	
	always @(posedge clk, posedge reset) begin // wp, rp
		if (reset==1'b1) begin
			wp <= 0;
			rp <= 0;
		end else begin
			if (wr_en_node==1'b1 && fifo_full==1'b0) // wr_en1ŁAFIFOtłȂƂɏ
				wp <= wp + 4'h1;
			if (inner_rd_en==1'b1 && fifo_empty==1'b0) // rd_en1ŁAFIFOemptyoȂɓǂݏo
				rp <= rp + 4'h1;
		end
	end
	assign fifo_full = (rp-4'h1==wp) ? 1'b1 : 1'b0; // rp1wptB1GggȂ傤Ȃ
	assign full = fifo_full;
	assign almost_full = (rp-4'h2==wp) ? 1'b1 : 1'b0;
	assign fifo_empty = (rp==wp) ? 1'b1 : 1'b0; // rp = wp̎AFIFO͋
	
	always @(posedge clk, posedge reset) begin // out_data
		if (reset==1'b1) begin
			out_data <= 0;
			out_mask <= 0;
		end else if (fifo_empty==1'b0 && ~(rd_en==1'b0 && outff_flag==1'b1)) begin
		// FIFOłȂAoutff1œǂݏoȂȊOoutffFIFO̓eǂݏo
			out_data <= data_node;
			out_mask <= mask_node;
		end
	end
	assign inner_rd_en = (fifo_empty==1'b0 && ~(rd_en==1'b0 && outff_flag==1'b1)) ? 1'b1 : 1'b0;
	
	always @(posedge clk, posedge reset) begin
		if (reset==1'b1)
			outff_flag <= 1'b0;
		else if (inner_rd_en==1'b1)
			outff_flag <= 1'b1;
		else if (rd_en==1'b1)
			outff_flag <= 1'b0;
	end
	assign dout = out_data;
	assign maskout = out_mask;
    assign empty = ~outff_flag;
	assign almost_empty = (outff_flag==1'b0 || (outff_flag==1'b1 && fifo_empty==1'b1)) ? 1'b1 : 1'b0;
	// AT[V
	// synthesis translate_off
	always @ (posedge clk) begin
		if (reset)
			;
		else
			if (rd_en && empty) begin
				$display("%m: at time %t ERROR : FIFOȂ̂Ƀ[h",$time);
				$stop;
			end
			if (wr_en && full) begin 
				$display("%m: at time %t ERROR : FIFOtȂ̂ɃCg",$time);
				$stop;
			end
	end
	// synthesis translate_on
endmodule
`default_nettype wire //ǉ
