 // Read/Write IO module
 // ReadWriteIO𓝊郂W[
 
 // 2009/5/22

`default_nettype none
`timescale 1ns / 1ps
 
 module read_write_io (reset, clk, clk90, read_timing, read_timing_1b, read_timing_2b, burst_read, output_data, rddata_valid, wrdata_fifo_data, wrdata_fifo_mask, dqs_enable, dqs_reset, ddr2_dq, ddr2_dqs, ddr2_dqs_n, ddr2_dm, sd_loop_in, sd_loop_out);
`include "./ddr2_cont_parameters.vh"
	input	wire	reset;
	input	wire	clk;
	input	wire	clk90;
	input	wire	read_timing;
	input	wire	read_timing_1b;
	input	wire	read_timing_2b;
	input	wire	burst_read;
	output	wire	[INTERFACE_DATA_WIDTH-1 : 0] output_data;
	output	wire	rddata_valid;
	
	input	wire	[INTERFACE_DATA_WIDTH-1 : 0] wrdata_fifo_data;
	input	wire	[INTERFACE_MASK_WIDTH-1 : 0] wrdata_fifo_mask;
	input	wire	dqs_enable;
	input	wire	dqs_reset;
	
	inout	wire	[DDR2_DATA_WIDTH-1: 0] ddr2_dq;		// DDR2DQ
	inout	wire	[DDR2_DQS_DM_WIDTH-1: 0] ddr2_dqs;	// DDR2DQS
	inout	wire	[DDR2_DQS_DM_WIDTH-1: 0] ddr2_dqs_n;	// DDR2DQS#
	output	wire	[DDR2_DQS_DM_WIDTH-1: 0] ddr2_dm;	// DDR2DM
	input	wire	sd_loop_in;	// DDR2̒xLZ邽߂̓̓pbh
	output	wire	sd_loop_out;	// DDR2̒xLZ邽߂̏o̓pbh

	wire	clkx, clk270;
	wire	[DDR2_DATA_WIDTH-1: 0] dq_tri_d0;	// DQ̃gCXe[gpDDRWX^D0
	wire	[DDR2_DATA_WIDTH-1: 0] dq_tri_d1;	// DQ̃gCXe[gpDDRWX^D1
	wire	[DDR2_DATA_WIDTH-1: 0] dq_tri_ce;	// DQ̃gCXe[gpDDRWX^CE
	wire	[DDR2_DATA_WIDTH-1: 0] dq_data_d0;	// DQ̃f[^pDDRWX^D0
	wire	[DDR2_DATA_WIDTH-1: 0] dq_data_d1;	// DQ̃f[^pDDRWX^D1
	wire	[DDR2_DATA_WIDTH-1: 0] dq_data_ce;	// DQ̃f[^pDDRWX^CE
	wire	[DDR2_DQS_DM_WIDTH-1: 0] dqs_reset_io;	// DQS̃Zbg
	wire	[DDR2_DQS_DM_WIDTH-1: 0] dqs_enable_io; // DQS̃Cl[u
	wire	[DDR2_DQS_DM_WIDTH-1: 0] dm_data_d0;	// DM̃f[^pDDRWX^D0
	wire	[DDR2_DQS_DM_WIDTH-1: 0] dm_data_d1;	// DM̃f[^pDDRWX^D1
	wire	[DDR2_DQS_DM_WIDTH-1: 0] dm_data_ce;	// DM̃f[^p
	wire	fb_read_timing;	// SD_LOOP_INɋAĂ[h̃^C~O
	reg		rdd_afifo_rd_en;	// rddata_afiforead_enable
	wire	rdd_afifo_empty;	// rddata_afifoempty
	wire	rdd_afifo_almost_empty;	// rddata_afifoalmost_empty
	wire	rdd_afifo_full;		// rddata_afifofull
	wire	rdd_afifo_almost_full;	// rddata_afifoalmost_full
	reg [INTERFACE_DATA_WIDTH-1 : 0] wrdata_1d;
	reg [INTERFACE_DATA_WIDTH-1 : 0] wrdata_2d;
	reg [INTERFACE_DATA_WIDTH-1 : 0] wrdata_3d;
	reg [INTERFACE_DATA_WIDTH-1 : 0] wrdata_4d;
	reg [INTERFACE_DATA_WIDTH/2-1 : 0] wrdata_3d_half;
	reg [INTERFACE_DATA_WIDTH/2-1 : 0] wrdata_4d_half;
	reg [INTERFACE_DATA_WIDTH/2-1 : 0] wrdata_5d_half;
	reg [INTERFACE_MASK_WIDTH-1 : 0] wrmask_1d;
	reg [INTERFACE_MASK_WIDTH-1 : 0] wrmask_2d;
	reg [INTERFACE_MASK_WIDTH-1 : 0] wrmask_3d;
	reg [INTERFACE_MASK_WIDTH-1 : 0] wrmask_4d;
	reg [INTERFACE_MASK_WIDTH/2-1 : 0] wrmask_3d_half;
	reg [INTERFACE_MASK_WIDTH/2-1 : 0] wrmask_4d_half;
	reg [INTERFACE_MASK_WIDTH/2-1 : 0] wrmask_5d_half;
	wire [DDR2_DQS_DM_WIDTH-1 : 0] dqs_out;
	wire gnd, vcc;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_enable_1d;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_enable_2d;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_enable_3d;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_enable_1d_dq;
	reg [DDR2_DATA_WIDTH-1 : 0] dqs_enable_2d_dq;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_enable_2d_mask;
	reg [DDR2_DATA_WIDTH-1 : 0] dqs_enable_3d_dq;
	reg [DDR2_DATA_WIDTH-1 : 0] dqs_enable_4d_dq;
	reg [DDR2_DATA_WIDTH-1 : 0] dqs_enable_4d_dq_clk90;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_enable_3d_mask;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_enable_4d_mask_clk90;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_reset_1d;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_reset_2d;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_reset_3d;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_reset_1d_dq;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_reset_2d_dq;
	reg [DDR2_DATA_WIDTH-1 : 0] dqs_reset_2d_dqtri;
	reg [DDR2_DQS_DM_WIDTH-1 : 0] dqs_reset_3d_dq;
	reg [DDR2_DATA_WIDTH-1 : 0] dqs_reset_3d_dqtri;
	wire [INTERFACE_DATA_WIDTH-1 : 0] dout;
	reg	[INTERFACE_DATA_WIDTH-1 : 0] dout_node;
	reg valid_node;
	wire	[DDR2_DATA_WIDTH-1: 0] dq_data;	// DQ̃f[^
	wire	dqs_clk; // DQSNbNABUFGʂĂ DQS0̂
	wire [DDR2_DQS_DM_WIDTH-1 : 0] dqs_enable_node;
	
	assign clkx = ~clk;
	assign clk270 = ~clk90;
	
	// f[^͍ŏIIclk90, clk270ŏo͂̂ŁAiXƃNbN炵ĂB
	always @ (posedge clk) begin
		if (reset) begin
			wrdata_1d <= 0;
			wrmask_1d <= 0;
		end else begin
			wrdata_1d <= wrdata_fifo_data;
			wrmask_1d <= wrdata_fifo_mask;
		end
	end
	
	// clk90, clk270ŃTv
	always @ (posedge clk270) begin
		if (reset==1'b1) begin
			wrdata_2d <= 0;
			wrmask_2d <= 0;
			wrdata_3d_half <= 0;
			wrmask_3d_half <= 0;
			wrdata_3d <= 0;
			wrdata_4d_half <= 0;
			wrmask_3d <= 0;
			wrmask_4d_half <= 0;
			wrdata_4d <= 0;
			wrdata_5d_half <= 0;
			wrmask_4d <= 0;
			wrmask_5d_half <= 0;
		end else begin
			wrdata_2d <= wrdata_1d;
			wrmask_2d <= wrmask_1d;
			wrdata_3d_half <= wrdata_2d[INTERFACE_DATA_WIDTH-1 : INTERFACE_DATA_WIDTH/2];
			wrmask_3d_half <= wrmask_2d[INTERFACE_MASK_WIDTH-1 : INTERFACE_MASK_WIDTH/2];
			wrdata_3d <= wrdata_2d;
			wrdata_4d_half <= wrdata_3d_half;
			wrmask_3d <= wrmask_2d;
			wrmask_4d_half <= wrmask_3d_half;
			wrdata_4d <= wrdata_3d;
			wrdata_5d_half <= wrdata_4d_half;
			wrmask_4d <= wrmask_3d;
			wrmask_5d_half <= wrmask_4d_half;
		end
	end
	assign dq_data_d0 = wrdata_4d[INTERFACE_DATA_WIDTH/2-1 : 0];
	assign dq_data_d1 = wrdata_5d_half;
	assign dq_data_ce = dqs_enable_4d_dq_clk90;
	assign dm_data_d0 = wrmask_4d[INTERFACE_MASK_WIDTH/2-1 : 0];
	assign dm_data_d1 = wrmask_5d_half;
	assign dm_data_ce = dqs_enable_4d_mask_clk90;

	// dqs_enable, dqs_resetclk̃NbNhC
	always @ (posedge clk) begin :Dq_Enable_Reset
		integer k;
		
		if (reset) begin
			dqs_enable_1d_dq  <= 0;
			dqs_reset_1d_dq  <= 0;
		end else begin
			dqs_reset_1d_dq <= {DDR2_DQS_DM_WIDTH{dqs_reset}};
			dqs_enable_1d_dq <= {DDR2_DQS_DM_WIDTH{dqs_enable}};
		end
	end
	always @ (posedge clk) begin :Dqs_Enable_Reset
		integer k;
		
		if (reset) begin
			dqs_enable_1d  <= 0;
			dqs_reset_1d  <= 0;
			dqs_enable_2d <= 0;
			dqs_reset_2d <= 0;
			dqs_enable_3d <= 0;
			dqs_reset_3d <= 0;
		end else begin
			dqs_enable_1d <= {DDR2_DQS_DM_WIDTH{dqs_enable}};
			dqs_reset_1d <= {DDR2_DQS_DM_WIDTH{dqs_reset}};
			dqs_enable_2d <= dqs_enable_1d;
			dqs_reset_2d <= dqs_reset_1d;
			dqs_enable_3d <= dqs_enable_2d;
			dqs_reset_3d <= dqs_reset_2d;
		end
	end
	
	always @ (posedge clk270) begin : Dqs_Loop
		integer k,m;
		
		if (reset) begin
			dqs_enable_2d_dq  <= 0;
			dqs_enable_2d_mask <= 0;
			dqs_reset_2d_dqtri <= 0;
			dqs_reset_2d_dq  <= 0;
			dqs_enable_3d_dq  <= 0;
			dqs_enable_3d_mask <= 0;
			dqs_reset_3d_dqtri <= 0;
			dqs_reset_3d_dq  <= 0;
			dqs_enable_4d_dq <= 0;
		end else begin
			for (k=0; k<=DDR2_DATA_WIDTH-1; k=k+1) begin
				dqs_enable_2d_dq[k] <= dqs_enable_1d_dq[k/8];
				dqs_reset_2d_dqtri[k] <= dqs_reset_1d_dq[k/8];
			end
			dqs_enable_2d_mask <= dqs_enable_1d_dq;
			dqs_reset_2d_dq  <= dqs_reset_1d_dq;
			dqs_enable_3d_dq  <= dqs_enable_2d_dq;
			dqs_enable_3d_mask <= dqs_enable_2d_mask;
			dqs_reset_3d_dqtri <= dqs_reset_2d_dqtri;
			dqs_reset_3d_dq  <= dqs_reset_2d_dq;
			dqs_enable_4d_dq  <= dqs_enable_3d_dq;
		end
	end
	always @(posedge clk90) begin : Dqs_clk90_Loop
		if (reset) begin
			dqs_enable_4d_dq_clk90 <= 0;
			dqs_enable_4d_mask_clk90 <= 0;
		end else begin
			dqs_enable_4d_dq_clk90 <= dqs_enable_3d_dq;
			dqs_enable_4d_mask_clk90 <= dqs_enable_3d_mask;
		end
	end

	assign dq_tri_d0 = ~dqs_enable_3d_dq;
	assign dq_tri_d1 = ~dqs_enable_4d_dq;
	assign dq_tri_ce = {DDR2_DATA_WIDTH{1'b1}}; // ɃCl[u
	assign dqs_enable_node = dqs_enable_2d | dqs_enable_3d;
		
	// ddr2_cont_iob.ṽCX^VG[V
	ddr2_cont_iob ddr2_cont_iob_inst(
		.clk90(clk90),
		.clk(clk),
		.reset(reset),
		.dq_data(dq_data),
		.dq_tri_d0(dq_tri_d0),
		.dq_tri_d1(dq_tri_d1),
		.dq_tri_ce(dq_tri_ce),
		.dq_data_d0(dq_data_d0),
		.dq_data_d1(dq_data_d1),
		.dq_data_ce(dq_data_ce),
		.dqs_reset(dqs_reset_2d),
		.dqs_enable(dqs_enable_node),
		.dqs_clk(dqs_clk),
		.dm_data_d0(dm_data_d0),
		.dm_data_d1(dm_data_d1),
		.dm_data_ce(dm_data_ce),
		.read_timing(read_timing),
		.read_timing_1b(read_timing_1b),
		.read_timing_2b(read_timing_2b),
		.fb_read_timing(fb_read_timing),
		.ddr2_dq(ddr2_dq),
		.ddr2_dqs(ddr2_dqs),
		.ddr2_dqs_n(ddr2_dqs_n),
		.ddr2_dm(ddr2_dm),
		.sd_loop_in(sd_loop_in),
		.sd_loop_out(sd_loop_out)
	);
	
	// rddata_afifo.ṽCX^VG[V
	rddata_afifo rddata_afifo_inst(
		.clk(clk),
		.dqs_clk(dqs_clk),
		.reset(reset),
		.rd_en(rdd_afifo_rd_en),
		.wr_en(fb_read_timing),
		.din(dq_data),
		.dout(dout),
		.empty(rdd_afifo_empty),
		.almost_empty(rdd_afifo_almost_empty),
		.full(rdd_afifo_full),
		.almost_full(rdd_afifo_almost_full)
	);
		
	// rdd_afifo_rd_en𐶐
	always @* begin
		if (rdd_afifo_empty) // empty͓̎ǂ݂Ȃ
			rdd_afifo_rd_en <= 1'b0;
		else
			rdd_afifo_rd_en <= 1'b1;
	end
	
	// valid_nodeAdout_nodeb`
	always @(posedge clk) begin
		if (reset) begin
			valid_node <= 1'b0;
			dout_node <= 0;
		end else begin
			valid_node <= rdd_afifo_rd_en;
			dout_node <= dout;
		end
	end
	assign output_data = dout_node;
	assign rddata_valid = valid_node;
endmodule
	