// [hEf[^pFIFO(rddata_afifo)񓯊FIFO
// CoregenŐ8rbg4̔񓯊FIFOCX^VG[VB
// DDR2̓vtFb`4Ȃ̂ŁAxReadWriteDDR2 SDRAM̃oX4{̃f[^ǂݏłB̃Rg[ł̓oX𑝂₳Ȃ߁AOɓo͂oXDDR2 SDRAM̃oX2{ƂāA2f[^ǂݏB

`default_nettype none
`timescale 1ns / 1ps

module rddata_afifo(clk, dqs_clk, reset, din, dout, rd_en, wr_en, empty, almost_empty, full, almost_full);
`include "./ddr2_cont_parameters.vh"
	input	wire	clk;
	input	wire	dqs_clk;
	input	wire	reset;
	input	wire	rd_en;
	input	wire	wr_en;
	input	wire	[DDR2_DATA_WIDTH-1 :0] din;
	output	wire	[INTERFACE_DATA_WIDTH-1 :0] dout;
	output	wire	empty;
	output	wire	almost_empty;
	output	wire	full;
	output	wire	almost_full;
	
	wire	empty_rise, empty_fall;
	wire	almost_empty_rise, almost_empty_fall;
	wire	full_rise, full_fall;
	wire	almost_full_rise, almost_full_fall;
	
	// 16rbg̔񓯊FIFOCX^VG[ViDQSNbN̗オŃf[^TvAʁj
//	DQS2intclk_FIFO DQS2intclk_FIFO_RISE(
	async_fifo_rise DQS2intclk_FIFO_RISE(
		.din	(din[15:0]),
		.rd_clk	(clk),
		.rst	(reset),
		.rd_en	(rd_en),
		.wr_en	(wr_en),
		.wr_clk	(dqs_clk),	// DQSNbN̗オAFIFOɓ͂
		.almost_empty	(almost_empty_rise),
		.almost_full	(almost_full_rise),
		.dout	(dout[15:0]),
		.empty	(empty_rise),
		.full	(full_rise)
	);
	
	// 16rbg̔񓯊FIFOCX^VG[ViDQSNbN̗Ńf[^TvAʁj
//	DQS2intclk_FIFO DQS2intclk_FIFO_FALL(
	async_fifo_fall DQS2intclk_FIFO_FALL(
		.din	(din[15:0]),	// din͗オƓ
		.rd_clk	(clk),
		.rst	(reset),
		.rd_en	(rd_en),
		.wr_en	(wr_en),
		.wr_clk	(dqs_clk),	// DQSNbN̗AFIFOɓ͂B
		.almost_empty	(almost_empty_fall),
		.almost_full	(almost_full_fall),
		.dout	(dout[31:16]),
		.empty	(empty_fall),
		.full	(full_fall)
	);
	
	// empty, almost_empty, full, almost_fullȂǂ̏B8rbgꂼFIFOɐMBׂĂ̏΁Aꂼ̐M͓ɕῶ̂ŁA1rbgoB
	assign empty = empty_rise | empty_fall;
	assign almost_empty = almost_empty_rise | almost_empty_fall;
	assign full = full_rise | full_fall;
	assign almost_full = almost_full_rise | almost_full_fall;
endmodule
	
