// Spartan3A Starter KitpDDR2 SDRAMRg[
//
// reset̓{^SW̓͂p[IZbg͂B
// dcm_locked_inɂ͑OiDCMlockedM蓖ĂBdcm_locked_outDDR2 SDRAMRg[DCMlockedB
//
// 2009/05/30

`default_nettype none
`timescale 1ns / 1ps

module ddr2_sdram_cont(sysclk, clk_out, reset, input_data, input_mask, read_write, output_data, input_address, addr_fifo_wren, wrdata_fifo_wren, addr_fifo_full, wrdata_fifo_full, rddata_valid, initialize_end, dcm_locked_in, dcm_locked_out, ddr2_clk, ddr2_clkb, ddr2_cke, ddr2_dqs, ddr2_dqs_n, ddr2_dq, ddr2_csb, ddr2_rasb, ddr2_casb, ddr2_web, ddr2_dm, ddr2_ba, ddr2_address, ddr2_odt, sd_loop_in, sd_loop_out);
	`include "./ddr2_cont_parameters.vh"
	
	input	wire	sysclk; // NbN
	output 	wire	clk_out; // NbNo
	input 	wire	reset;
	input 	wire	[INTERFACE_DATA_WIDTH-1 : 0] input_data;
	input	wire	[INTERFACE_MASK_WIDTH-1 : 0] input_mask;
	input	wire	read_write;
	output	wire	[INTERFACE_DATA_WIDTH-1 : 0] output_data;
	input	wire	[USER_INPUT_ADDRESS_WIDTH-1 : 0] input_address;
	input	wire	addr_fifo_wren; // AhXpFIFȌ݃Cl[u
	input	wire	wrdata_fifo_wren; // FIFȌ݃Cl[u
	output	reg		addr_fifo_full;
	output	reg		wrdata_fifo_full;
	output	wire	rddata_valid; // ǂݏof[^L
	output	wire	initialize_end;
	input	wire	dcm_locked_in;
	output	wire	dcm_locked_out;
	output	wire	[QUANTITY_OF_CLK_OUTPUT-1 : 0] ddr2_clk;
	output	wire	[QUANTITY_OF_CLK_OUTPUT-1 : 0] ddr2_clkb;
	output	wire	ddr2_cke;
	inout	wire	[DDR2_DQS_DM_WIDTH-1 : 0] ddr2_dqs;
	inout	wire	[DDR2_DQS_DM_WIDTH-1 : 0] ddr2_dqs_n;
	inout	wire	[DDR2_DATA_WIDTH-1 : 0] ddr2_dq;
	output	wire	ddr2_csb;
	output	wire	ddr2_rasb;
	output	wire	ddr2_casb;
	output	wire	ddr2_web;
	output	wire	[DDR2_DQS_DM_WIDTH-1 : 0] ddr2_dm;
	output	wire	[1:0] ddr2_ba;
	output	wire	[DDR2_ADDRESS_WIDTH-1 : 0] ddr2_address;
	output	wire	ddr2_odt;
	input	wire	sd_loop_in;
	output	wire	sd_loop_out;
	
	wire clk, clk90, clk1_16;
	wire [USER_INPUT_ADDRESS_WIDTH-1 : 0] address, next_address;
	wire read_writex, next_read_writex;
	wire addr_fifo_empty, addr_fifo_almost_empty, addr_fifo_rden;
	wire wrdata_fifo_empty, wrdata_fifo_almost_empty, wrdata_fifo_rden;
	wire dqs_enable, dqs_reset, write_timing, read_timing, burst_read;
	wire [INTERFACE_DATA_WIDTH-1 : 0] wrdata_fifo_data;
	wire [INTERFACE_MASK_WIDTH-1 : 0] wrdata_fifo_mask;
	wire wrdata_fifo_almost_full;
	wire dcm_locked_node;
	wire reset_node;
	wire addr_fifo_full_node, wrdata_fifo_full_node;
	wire addr_fifo_almost_full;
	wire read_timing_1b;
	wire read_timing_2b;

	parameter	AFIFO_IDLE			= 3'b001,
				AFIFO_ALMOST_FULL	= 3'b010,
				AFIFO_FULL			= 3'b100;
	reg [2:0] afifo_cs, afifo_ns;
	
	parameter	WFIFO_IDLE			= 3'b001,
				WFIFO_ALMOST_FULL	= 3'b010,
				WFIFO_FULL			= 3'b100;
	reg [2:0] wfifo_cs, wfifo_ns;
	
	assign reset_node = reset | ~dcm_locked_node;
	
	dcm_module dcm_module_inst(
		.sysclk(sysclk),
		.reset(reset_node),
		.ddr2_clk(ddr2_clk),
		.ddr2_clkb(ddr2_clkb),
		.clk(clk),
		.clk90(clk90),
		.clk1_16(clk1_16),
		.dcm_locked_in(dcm_locked_in),
		.dcm_locked_out(dcm_locked_node)
	);
	assign dcm_locked_out = dcm_locked_node;
	
	controller controller_inst (
		.clk(clk),
		.clk1_16(clk1_16),
		.reset(reset_node),
		.address(address),
		.read_writex(read_writex),
		.next_address(next_address),
		.next_read_writex(next_read_writex),
		.addr_fifo_rden(addr_fifo_rden),
		.addr_fifo_empty(addr_fifo_empty),
		.addr_fifo_almost_empty(addr_fifo_almost_empty),
		.wrdata_fifo_empty(wrdata_fifo_empty),
		.wrdata_fifo_almost_empty(wrdata_fifo_almost_empty),
		.wrdata_fifo_rden(wrdata_fifo_rden),
		.ddr2_rasb(ddr2_rasb),
		.ddr2_casb(ddr2_casb),
		.ddr2_web(ddr2_web),
		.ddr2_ba(ddr2_ba),
		.ddr2_address(ddr2_address),
		.ddr2_cke(ddr2_cke),
		.ddr2_csb(ddr2_csb),
		.ddr2_odt(ddr2_odt),
		.dqs_enable(dqs_enable),
		.dqs_reset(dqs_reset),
		.write_timing(write_timing),
		.read_timing(read_timing),
		.read_timing_1b(read_timing_1b),
		.read_timing_2b(read_timing_2b),
		.burst_read(burst_read),
		.initialize_end(initialize_end)
	);
	
	read_write_io read_write_io_inst (
		.reset(reset_node),
		.clk(clk),
		.clk90(clk90),
		.read_timing(read_timing),
		.read_timing_1b(read_timing_1b),
		.read_timing_2b(read_timing_2b),
		.burst_read(burst_read),
		.output_data(output_data),
		.rddata_valid(rddata_valid),
		.wrdata_fifo_data(wrdata_fifo_data),
		.wrdata_fifo_mask(wrdata_fifo_mask),
		.dqs_enable(dqs_enable),
		.dqs_reset(dqs_reset),
		.ddr2_dq(ddr2_dq),
		.ddr2_dqs(ddr2_dqs),
		.ddr2_dqs_n(ddr2_dqs_n),
		.ddr2_dm(ddr2_dm),
		.sd_loop_in(sd_loop_in),
		.sd_loop_out(sd_loop_out)
	);
	
	addr_fifo addr_fifo_inst (
		.clk(clk),
		.reset(reset_node),
		.din(input_address),
		.read_write(read_write),
		.wr_en(addr_fifo_wren),
		.rd_en(addr_fifo_rden),
		.dout(address),
		.rw_out(read_writex),
		.full(addr_fifo_full_node),
		.empty(addr_fifo_empty),
		.next_dout(next_address),
		.next_rw_out(next_read_writex),
		.almost_empty(addr_fifo_almost_empty),
		.almost_full(addr_fifo_almost_full)
	);
	
	wrdata_fifo wrdata_fifo_inst (
		.clk(clk),
		.reset(reset_node),
		.din(input_data),
		.maskin(input_mask),
		.rd_en(wrdata_fifo_rden),
		.wr_en(wrdata_fifo_wren),
		.full(wrdata_fifo_full_node),
		.almost_full(wrdata_fifo_almost_full),
		.empty(wrdata_fifo_empty),
		.almost_empty(wrdata_fifo_almost_empty),
		.dout(wrdata_fifo_data),
		.maskout(wrdata_fifo_mask)
	);
	assign clk_out = clk;
	
	// addr_fifo_full𓯊o͂Xe[g}V
	always @(posedge clk) begin 
		if (reset_node)
			afifo_cs <= AFIFO_IDLE;
		else
			afifo_cs <= afifo_ns;
	end
	always @* begin
		case(afifo_cs)
			AFIFO_IDLE : begin
				addr_fifo_full <= 1'b0;
				if (addr_fifo_almost_full)
					afifo_ns <= AFIFO_ALMOST_FULL;
				else
					afifo_ns <= AFIFO_IDLE;
			end
			AFIFO_ALMOST_FULL : begin
				addr_fifo_full <= 1'b1;
				if (addr_fifo_full_node)
					afifo_ns <= AFIFO_FULL;
				else if (~addr_fifo_almost_full)
					afifo_ns <= AFIFO_IDLE;
				else
					afifo_ns <= AFIFO_ALMOST_FULL;
			end
			AFIFO_FULL : begin
				addr_fifo_full <= 1'b1;
				if (~addr_fifo_full_node)
					afifo_ns <= AFIFO_ALMOST_FULL;
				else
					afifo_ns <= AFIFO_FULL;
			end
		endcase
	end
	
	// wrdata_fifo_full𓯊o͂Xe[g}V
	always @(posedge clk) begin 
		if (reset_node)
			wfifo_cs <= WFIFO_IDLE;
		else
			wfifo_cs <= wfifo_ns;
	end
	always @* begin
		case(wfifo_cs)
			WFIFO_IDLE : begin
				wrdata_fifo_full <= 1'b0;
				if (wrdata_fifo_almost_full)
					wfifo_ns <= WFIFO_ALMOST_FULL;
				else
					wfifo_ns <= WFIFO_IDLE;
			end
			WFIFO_ALMOST_FULL : begin
				wrdata_fifo_full <= 1'b1;
				if (wrdata_fifo_full_node)
					wfifo_ns <= WFIFO_FULL;
				else if (~wrdata_fifo_almost_full)
					wfifo_ns <= WFIFO_IDLE;
				else
					wfifo_ns <= WFIFO_ALMOST_FULL;
			end
			WFIFO_FULL : begin
				wrdata_fifo_full <= 1'b1;
				if (~wrdata_fifo_full_node)
					wfifo_ns <= WFIFO_ALMOST_FULL;
				else
					wfifo_ns <= WFIFO_FULL;
			end
		endcase
	end
				
endmodule
