// DDR2 SDRAM CONTROLLERIOB̃CX^XW߂W[
// DQSBUFGCX^VG[VDQ󂯂IOBɃNbNƂēnÃW[̊O̔񓯊FIFOɂ͑̃NbNƂēnB
// 
// 2008/04/03 : Ver. 1.1 : dqs[0]̂ݎgp悤ɕύX

`default_nettype none
`timescale 1ns / 1ps


module ddr2_cont_iob(clk90, clk, reset, dq_data, dq_tri_d0, dq_tri_d1, dq_tri_ce, dq_data_d0, dq_data_d1, dq_data_ce, dqs_reset, dqs_enable, dqs_clk, dm_data_d0, dm_data_d1, dm_data_ce, read_timing, read_timing_1b, read_timing_2b, fb_read_timing, ddr2_dq, ddr2_dqs, ddr2_dqs_n, ddr2_dm, sd_loop_in, sd_loop_out);
`include "./ddr2_cont_parameters.vh"
	input	wire	clk90;		// 90xʑ̃NbN
	input	wire	clk;		// o͗pAyєėpNbN
	input	wire	reset;		// Zbg
	output	wire	[DDR2_DATA_WIDTH-1: 0] dq_data;	// DQ̃f[^
	input	wire	[DDR2_DATA_WIDTH-1: 0] dq_tri_d0;	// DQ̃gCXe[gpDDRWX^D0
	input	wire	[DDR2_DATA_WIDTH-1: 0] dq_tri_d1;	// DQ̃gCXe[gpDDRWX^D1
	input	wire	[DDR2_DATA_WIDTH-1: 0] dq_tri_ce;	// DQ̃gCXe[gpDDRWX^CE
	input	wire	[DDR2_DATA_WIDTH-1: 0] dq_data_d0;	// DQ̃f[^pDDRWX^D0
	input	wire	[DDR2_DATA_WIDTH-1: 0] dq_data_d1;	// DQ̃f[^pDDRWX^D1
	input	wire	[DDR2_DATA_WIDTH-1: 0] dq_data_ce;	// DQ̃f[^pDDRWX^CE
	input	wire	[DDR2_DQS_DM_WIDTH-1: 0] dqs_reset;	// DQS̃Zbg
	input	wire	[DDR2_DQS_DM_WIDTH-1: 0] dqs_enable; // DQS̃Cl[u
	output	wire	dqs_clk; // DQSNbNABUFGʂĂ DQS0̂
	input	wire	[DDR2_DQS_DM_WIDTH-1: 0] dm_data_d0;	// DM̃f[^pDDRWX^D0
	input	wire	[DDR2_DQS_DM_WIDTH-1: 0] dm_data_d1;	// DM̃f[^pDDRWX^D1
	input	wire	[DDR2_DQS_DM_WIDTH-1: 0] dm_data_ce;	// DM̃f[^p
	input	wire	read_timing;	// [h̃^C~O,SD_LOOP_OUTo͂
	input	wire	read_timing_1b; // [h̃^C~O1NbNO
	input	wire	read_timing_2b; // [h̃^C~O2NbNO
	output	wire	fb_read_timing;	// SD_LOOP_INɋAĂ[h̃^C~O
	
	inout	wire	[DDR2_DATA_WIDTH-1: 0] ddr2_dq;		// DDR2DQ
	inout	wire	[DDR2_DQS_DM_WIDTH-1: 0] ddr2_dqs;	// DDR2DQS
	inout	wire	[DDR2_DQS_DM_WIDTH-1: 0] ddr2_dqs_n;	// DDR2DQS#
	output	wire	[DDR2_DQS_DM_WIDTH-1: 0] ddr2_dm;	// DDR2DM
	input	wire	sd_loop_in;	// DDR2̒xLZ邽߂̓̓pbh
	(* IOB = "FORCE" *)output	reg	sd_loop_out;	// DDR2̒xLZ邽߂̏o̓pbh
	
	wire [DDR2_DQS_DM_WIDTH-1: 0] dqs_clk_node;
	wire dqs_clk_bufg;

	generate // DQ̃CX^X
	genvar i;
		for (i=DDR2_DATA_WIDTH-1; i>=0; i=i-1) begin: DQ_IOB_INST
			dq_io_pad dq_io_pad_inst(
				.input_clk(dqs_clk_bufg),
				.clk(clk),
				.clk90(clk90),
				.reset(reset),
				.io_pad(ddr2_dq[i]),
				.dq_data_from_io(dq_data[i]),
				.tri_ddr_ce_to_io(dq_tri_ce[i]),
				.tri_ddr_d0_to_io(dq_tri_d0[i]),
				.tri_ddr_d1_to_io(dq_tri_d1[i]),
				.data_ddr_ce_to_io(dq_data_ce[i]),
				.data_ddr_d0_to_io(dq_data_d0[i]),
				.data_ddr_d1_to_io(dq_data_d1[i])
			);
		end
	endgenerate
	
	generate // DQS̃CX^X
	genvar j;
		for (j=DDR2_DQS_DM_WIDTH-1; j>=0; j=j-1) begin: DQS_IOB_INST
			dqs_io_pad dqs_io_pad_inst(
				.clk(clk),
				.reset(reset),
				.io_pad(ddr2_dqs[j]),
				.dqs_reset(dqs_reset[j]),
				.dqs_enable(dqs_enable[j]),
				.dqs_clk(dqs_clk_node[j])
			);
		end
	endgenerate
	
	generate // DQS#̃CX^X
	genvar k;
		for (k=DDR2_DQS_DM_WIDTH-1; k>=0; k=k-1) begin: DQSB_IOB_INST
			dqsb_io_pad dqsb_io_pad_inst(
				.clk(clk),
				.reset(reset),
				.io_pad(ddr2_dqs_n[k]),
				.dqs_reset(dqs_reset[k]),
				.dqs_enable(dqs_enable[k]),
				.dqs_clk()
			);
		end
	endgenerate
	
	BUFG BUFG_inst(
		.O(dqs_clk_bufg),
		.I(dqs_clk_node[0])
	);
	assign dqs_clk = dqs_clk_bufg;
	
	generate // DM̃CX^X
	genvar m;
		for (m=DDR2_DQS_DM_WIDTH-1; m>=0; m=m-1) begin: DM_IOB_INST
			dm_io_pad dm_io_pad_inst(
				.clk90(clk90),
				.reset(reset),
				.io_pad(ddr2_dm[m]),
				.data_ddr_ce_to_io(dm_data_ce[m]),
				.data_ddr_d0_to_io(dm_data_d0[m]),
				.data_ddr_d1_to_io(dm_data_d1[m])
			);
		end
	endgenerate
	
	always @ (posedge clk) begin
		if (reset)
			sd_loop_out = 1'b0;
		else begin
			sd_loop_out = read_timing_1b;
		end
	end
	
	assign fb_read_timing = sd_loop_in;
endmodule
		