// DCM module
// 200MHz͂āA200MHzclkclk90𐶐BDDR2 SDRAMւ̏o̓NbNADDR2_CLKDDR2_CLKB

`default_nettype none
`timescale 1ns / 1ps

(* KEEP_HIERARCHY = "TRUE" *)module dcm_module (sysclk, reset, ddr2_clk, ddr2_clkb, clk, clk90, clk1_16, dcm_locked_in, dcm_locked_out);
	`include "./ddr2_cont_parameters.vh"
	input	wire	sysclk;
	input	wire	reset;
	output 	wire	[QUANTITY_OF_CLK_OUTPUT-1 : 0] ddr2_clk;
	output 	wire	[QUANTITY_OF_CLK_OUTPUT-1 : 0] ddr2_clkb;
	output	wire	clk;
	output	wire	clk90;
	output	wire	clk1_16;
	input	wire	dcm_locked_in;
	output	wire	dcm_locked_out;
	
	wire clk_bufg, clk_node, clk90_node, clk1_16_node, dcm1_locked;
	wire clk90_bufg, clk1_16_bufg;
		
	DCM DCM_INST1 (
		.CLKIN(sysclk),
		.CLKFB(clk_bufg),
		.DSSEN(1'b0),
		.PSINCDEC(1'b0),
		.PSEN(1'b0),
		.PSCLK(1'b0),
		.RST(1'b0), 
		// .RST(~dcm_locked_in), 	// OiDCMbN܂ŃZbg
		.CLK0(clk_node),
		.CLK90(clk90_node),
		.CLK180(),
		.CLK270(),
		.CLK2X(),
		.CLK2X180(),
		.CLKDV(clk1_16_node),
		.CLKFX(),
		.CLKFX180(),
		.LOCKED(dcm1_locked),
		.PSDONE(),
		.STATUS()
	);
	defparam DCM_INST1.CLKIN_PERIOD = 6.7;
	defparam DCM_INST1.DLL_FREQUENCY_MODE = "LOW";
	defparam DCM_INST1.DUTY_CYCLE_CORRECTION = "TRUE";
	defparam DCM_INST1.CLKDV_DIVIDE = 16.0;
	defparam DCM_INST1.PHASE_SHIFT = 0;
	defparam DCM_INST1.CLKOUT_PHASE_SHIFT = "NONE";
	defparam DCM_INST1.STARTUP_WAIT = "FALSE";
	// defparam DCM_INST1.FACTORY_JF = 16'hFFFF;
	
	BUFG CLK_BUFG_INST (
		.I(clk_node),
		.O(clk_bufg)
	);
	assign clk = clk_bufg;
	
	BUFG CLK90_BUFG_INST (
		.I(clk90_node),
		.O(clk90_bufg)
	);
	assign clk90 = clk90_bufg;
	
	BUFG CLK1_16_BUFG_INST (
		.I(clk1_16_node),
		.O(clk1_16_bufg)
	);
	assign clk1_16 = clk1_16_bufg;
	
	generate
	genvar i;
		for(i=0; i<=QUANTITY_OF_CLK_OUTPUT-1; i=i+1) begin: DDR2_CLK
			ODDR2 #(
				.DDR_ALIGNMENT("NONE"),
				.SRTYPE("SYNC")
			) ODDR2_CLK (
				.Q(ddr2_clk[i]),
				.C0(clk_bufg),
				.C1(~clk_bufg),
				.CE(1'b1),
				.D0(1'b1),
				.D1(1'b0),
				.R(reset),
				.S(1'b0)
			);
			
			ODDR2 #(
				.DDR_ALIGNMENT("NONE"),
				.SRTYPE("SYNC")
			) ODDR2_CLKB (
				.Q(ddr2_clkb[i]),
				.C0(clk_bufg),
				.C1(~clk_bufg),
				.CE(1'b1),
				.D0(1'b0),
				.D1(1'b1),
				.R(reset),
				.S(1'b0)
			);
		end
	endgenerate
	
	assign dcm_locked_out = dcm1_locked;
endmodule
