// DDR2 CONTROLLER
// 2007.01.05
// 2008/03/03 Ver. 1.1 : equal_active_bank̔rrow_addrbank_addrrĂȂoOC
// 2008/03/05 Ver. 1.2 : JAhX𒴂ăo[XgꍇɁAoNv`[WACTR}hĂREADWRITER}h邪A̍ۂCLK0xCLK180x̃NbN̈ႢŃAhX̃AhXɂȂĂ܂BoNAhX̂CLK180xŃb`AhXgpB
// 2008/03/06 Ver. 1.3 : dqs_enableo͂Xe[g}VɃoOBWRITE1ԂJĂxWRITEƂidle_detsXe[gɖ߂Ă܂AWRITEł邱Ƃ𔻒肵write_detsXe[gɑJڂKvB
// 2008/03/07 Ver. 1.4 : row_addr, bank_addrɓaddress̃rbgtB[hԈĂB
// 2008/04/23 Ver. 1.5 : DDR2 SDRAM̃CjVCYI0x5555, 0xAAAAp^[ށB̌AIDELAY𑝂₵Ȃ琳ɓǂ߂|CgTBIDELAYő܂ōsAɃf[^ǂ߂EChE̐^񒆂܂Œx߂B
// 2008/06/08 Ver. 1.6 : DQxēNbNŃf[^[h@͂߂āADQSDQTv@ɉ߂
// 2008/07/25 Ver. 1.7 : RAS,CAS,WEAo̓AhX1NbNւ炵
// 2008/08/13 Ver. 1.8 : TPARTRTWύX
// 2008/11/30 Ver. 1.9 : ODTWritêONɂ悤ɕύX
// 2009/05/05 Ver. 2.0 : Spartan3A Starter KitpɕύX

`default_nettype none
`timescale 1ns / 1ps

// `define DDR2_ODT_ENABLE // ODTCl[u

module controller(clk, clk1_16, reset, address, read_writex, next_address, next_read_writex, addr_fifo_empty, addr_fifo_almost_empty, addr_fifo_rden, wrdata_fifo_empty, wrdata_fifo_almost_empty, wrdata_fifo_rden, ddr2_rasb, ddr2_casb, ddr2_web, ddr2_ba, ddr2_address, ddr2_cke, ddr2_csb, ddr2_odt, dqs_enable, dqs_reset, write_timing, read_timing, read_timing_1b, read_timing_2b, burst_read, initialize_end);
	`include "./ddr2_cont_parameters.vh"

	input clk, clk1_16, reset;
	input [USER_INPUT_ADDRESS_WIDTH-1:0] address;
	input read_writex;
	input [USER_INPUT_ADDRESS_WIDTH-1:0] next_address;
	input next_read_writex;
	input addr_fifo_empty, addr_fifo_almost_empty;
	output addr_fifo_rden;
	input wrdata_fifo_empty, wrdata_fifo_almost_empty;
	output wrdata_fifo_rden;
	output ddr2_rasb, ddr2_casb, ddr2_web;
	output [1:0] ddr2_ba;
	output [DDR2_ADDRESS_WIDTH-1:0] ddr2_address;
	output ddr2_cke, ddr2_csb, ddr2_odt, dqs_enable, dqs_reset;
    output write_timing, read_timing, burst_read;
	output read_timing_1b;
	output read_timing_2b;
	output initialize_end;
	
	wire clk, clk1_16, reset;
	wire [USER_INPUT_ADDRESS_WIDTH-1:0] address;
	wire read_writex;
	wire [USER_INPUT_ADDRESS_WIDTH-1:0] next_address;
	wire next_read_writex;
	wire addr_fifo_empty, addr_fifo_almost_empty;
	wire addr_fifo_rden;
	wire wrdata_fifo_empty, wrdata_fifo_almost_empty;
	wire wrdata_fifo_rden;
	wire ddr2_rasb, ddr2_casb, ddr2_web;
	wire [1:0] ddr2_ba;
	wire [DDR2_ADDRESS_WIDTH-1:0] ddr2_address;
	reg ddr2_cke, dqs_enable;
	wire ddr2_csb;
	reg  dqs_reset;
	wire write_timing, read_timing, burst_read;
	wire read_timing_1b;
	wire read_timing_2b;
	reg initialize_end;
	
	wire clkx;
	wire [DDR2_ADDRESS_WIDTH-1:0] row_addr, next_row_addr;
	reg [DDR2_COLUMN_ADDRESS_WIDTH-1:0] column_addr;
	wire [1:0] bank_addr, next_bank_addr;
	reg [1:0] TRP;
	reg [1:0] TMRD;
	reg [1:0] TRCD;
	reg [2:0] TPAR;
	reg [2:0] TRTW;
	reg [2:0] TPAW;
	reg [2:0] TWTR;
	reg [3:0] TRFC;
	reg [3:0] TRC;
	reg [2:0] TRAS;
	reg [1:0] TRTR, TWTW;
	reg [11:0] initial_count;
	reg initial_start, initial_startx;
	reg read_cmd_issue, read_cmd_issue_1d;
	
	parameter	idle_init=				14'b00000000000001, 
				pall1_init=				14'b00000000000010,
				emr2s_init=				14'b00000000000100,
				emr3s_init=				14'b00000000001000,
				emrs_dllena_init=		14'b00000000010000,
				mrs_dllrst_init=		14'b00000000100000,
				pall2_init=				14'b00000001000000,
				ref1_init=				14'b00000010000000,
				ref2_init=				14'b00000100000000,
				mrs_init=				14'b00001000000000,
				emrs_ocd_def_init=		14'b00010000000000,
				emrs_ocd_exit_init=		14'b00100000000000,
				wait_init_end=			14'b01000000000000,
				init_end=				14'b10000000000000;
				
	parameter	NOP=	8'b00000001,
				ACT=	8'b00000010,
				READ=	8'b00000100,
				WRIT=	8'b00001000,
				PALL=	8'b00010000,
				MRS=	8'b00100000,
				EMRS=	8'b01000000,
				REF=	8'b10000000;
				
	parameter	IDLE_ODT=		4'b0001,
				WRITE_ACTIVE=	4'b0010,
				WRITE_TEST=		4'b0100,
				WRITE_HOLDOFF1=	4'b1000;

	reg [13:0] n_init, c_init; // idle_init, etc...
	reg [7:0] n_state, c_state, b_state, b2_state; // NOP, etc...
	
	parameter	idle_dets=	3'b001,
				write_dets=	3'b010,
				write_wait=	3'b100;
								
	reg [2:0] ns_dets, cs_dets; // idle_dets
	
	reg cke_stat;
	reg [USER_INPUT_ADDRESS_WIDTH-3 : USER_INPUT_ADDRESS_WIDTH-3-(DDR2_ADDRESS_WIDTH-1)] active_row_addr;
	reg [USER_INPUT_ADDRESS_WIDTH-1 : USER_INPUT_ADDRESS_WIDTH-2] active_bank_addr;
	wire ref_state;
	reg ref_then_by_now;
	wire ref_req;
	reg [MAX_REFRESH_COUNT_LENGTH-1 : 0] ref_count;
	wire equal_active_bank, equal_active_bank_next;
	reg equal_active_bank_1d, addr_fifo_empty_1d, addr_fifo_almost_empty_1d;
	reg read_writex_1d, next_read_writex_1d;
	reg equal_active_bank_next_1d, equal_active_bank_next_2d;
	reg activate_bank;
	reg [DDR2_ADDRESS_WIDTH-1 :0] ddr2_addr_node, ddr2_addr_node_1d, ddr2_addr_node_2d;
	reg [1:0] bank_addr_node, bank_addr_node_1d, bank_addr_node_2d;
	reg [DDR2_ADDRESS_WIDTH-1 :0] ddr2_addr_node_3d;
	reg [1:0] bank_addr_node_3d;
	reg rasb_node, casb_node, web_node;
	reg rasb_node_1d, casb_node_1d, web_node_1d;
	reg rasb_node_2d, casb_node_2d, web_node_2d;
	reg rasb_node_3d, casb_node_3d, web_node_3d;
	wire wrdata_fifo_rden_node;
	reg [4:0] dll_reset_cnt;
	reg dll_reset_end, dll_reset_flag;
	reg before_cmd_is_ACT;
	reg [CAS_LATENCY :0] read_timing_node;
	reg [CLK2PALLA_CNT_WIDTH-1 :0] cke2palla_cnt;
	reg cke2palla_ena;
	reg [3:0] ns_odt, cs_odt;
	reg odt_node, odt_node_1d;
	reg cke_stat_clk0;
	
	assign ddr2_csb = 1'b0;
	assign clkx = ~clk;
	
	assign row_addr = address[USER_INPUT_ADDRESS_WIDTH-3 : USER_INPUT_ADDRESS_WIDTH-3-(DDR2_ADDRESS_WIDTH-1)];
	always @(posedge clk) begin
		if (reset==1'b1)
			column_addr <= 0;
		else
			column_addr <= address[DDR2_COLUMN_ADDRESS_WIDTH-1 :0];
	end
	assign bank_addr = address[USER_INPUT_ADDRESS_WIDTH-1 : USER_INPUT_ADDRESS_WIDTH-2];
	assign next_row_addr = next_address[USER_INPUT_ADDRESS_WIDTH-3 : USER_INPUT_ADDRESS_WIDTH-3-(DDR2_ADDRESS_WIDTH-1)];
	assign next_bank_addr = next_address[USER_INPUT_ADDRESS_WIDTH-1 : USER_INPUT_ADDRESS_WIDTH-2];
	
	// ݃ANeBuȃoNARowAhXb`Ă
	always @(posedge clk) begin
		if (reset) begin
			active_row_addr <= 0;
			active_bank_addr <= 0;
		end else if (c_state==ACT) begin // DDR2 SDRAMANeBx[g鎞
			active_row_addr <= row_addr;
			active_bank_addr <= bank_addr;
		end
	end
	assign equal_active_bank = (active_row_addr==row_addr && active_bank_addr==bank_addr) ? 1'b1 : 1'b0;
	assign equal_active_bank_next = (active_row_addr==next_row_addr && active_bank_addr==next_bank_addr) ? 1'b1 : 1'b0;
	
	always @(posedge clk) begin // ȑÕR}hACTR}hAACTR}h̎WRITAREADR}h̎́AoNAROWAhX`FbN邽
		if (reset)
			before_cmd_is_ACT <= 1'b0;
		else if (c_state == ACT)
			before_cmd_is_ACT <= 1'b1;
		// else if (n_state != NOP) // ̔ɉeyڂȂ悤ɁA1NbN߂
		else if (c_state != NOP) // ddr2łREAD, WRITĚɕKNOP
			before_cmd_is_ACT <= 1'b0;
	end
	
	always @(posedge clk) begin // ACTR}h𔭍sĂԂ
		if (reset)
			activate_bank <= 1'b0;
		else if (c_state == ACT) // ACTR}hs
			activate_bank <= 1'b1;
		else if (c_state == PALL) // SoNv`[W
			activate_bank <= 1'b0;
	end
	
	always @(posedge clk) begin // g΍̂߂1񃉃b`
		if (reset) begin
			equal_active_bank_1d <= 1'b0;
			addr_fifo_empty_1d <= 1'b0;
			addr_fifo_almost_empty_1d <= 1'b0;
			read_writex_1d <= 1'b0;
			equal_active_bank_next_1d <= 1'b0;
			equal_active_bank_next_2d <= 1'b0;
			next_read_writex_1d <= 1'b0;
		end else begin
			equal_active_bank_1d <= equal_active_bank;
			addr_fifo_empty_1d <= addr_fifo_empty;
			addr_fifo_almost_empty_1d <= addr_fifo_almost_empty;
			read_writex_1d <= read_writex;
			equal_active_bank_next_1d <= equal_active_bank_next;
			equal_active_bank_next_2d <= equal_active_bank_next_1d;
			next_read_writex_1d <= next_read_writex;
		end
	end
		
	// e^C~OK肷 ݒl|2
	// TRP(PRECHARGE command period) 15ns (3 clock cycles by 200MHz)
	always @(posedge clk) begin
		if (reset)
			TRP <= 0;
		else if (c_state==PALL)
			TRP <= 1;
		else if (TRP != 0)
			TRP <= TRP - 1;
	end
	
	// TMRD(LOAD MODE REGISTER command cycle time) 2cycles (2 clock cycles by 200MHz)(3clocks)
	always @(posedge clk) begin
		if (reset)
			TMRD <= 0;
		else if (c_state==MRS || c_state==EMRS)
			TMRD <= 1;
		else if (TMRD != 0)
			TMRD <= TMRD - 1;
	end
	
	// TRFC(AUTO REFRESH command period) 75ns (15 clock cycles by 200MHz)
	always @(posedge clk) begin
		if (reset)
			TRFC <= 0;
		else if (c_state==REF)
			TRFC <= 14;
		else if (TRFC != 0)
			TRFC <= TRFC - 1;
	end
	
	// TRCD(ACTIVE to READ or WRITE delay) 15ns (3 clock cycles by 200MHz)
	always @(posedge clk) begin
		if (reset)
			TRCD <= 0;
		else if (c_state==ACT)
			TRCD <= 1;
		else if (TRCD != 0)
			TRCD <= TRCD - 1;
	end
	
	// TRAS(ACTIVE to PRECHARGE command) 40ns ~ 70000ns (8 clock cycles by 200MHz)
	always @(posedge clk) begin
		if (reset)
			TRAS <= 0;
		else if (c_state==ACT)
			TRAS <= 6;
		else if (TRAS != 0)
			TRAS <= TRAS - 1;
	end
	
	// TRC(ACTIVE to ACTIVE/AUTO REFRESH command period) 55ns (11 clock cycles by 133MHz)
	always @(posedge clk) begin
		if (reset)
			TRC <= 0;
		else if (c_state==REF)
			TRC <= 9;
		else if (TRC != 0)
			TRC <= TRC - 1;
	end
	
	// TPAW(Precharge After Write time) WriteR}ȟ̃v`[Ws 7clock(TWR܂)
	always @(posedge clk) begin
		if (reset)
			TPAW <= 0;
		else if (c_state==WRIT)
			TPAW <= 5; // Write command + 4burst input data + tWR(3 clock)
		else if (TPAW != 0)
			TPAW <= TPAW - 1;
	end
	
	// TPAR(Precharge After Read time) ReadR}ȟ̃v`[Ws 2clock(3clock)
	always @(posedge clk) begin
		if (reset)
			TPAR <= 0;
		else if (c_state==READ)
			TPAR <= 1;
		else if (TPAR != 0)
			TPAR <= TPAR - 1;
	end
	
	// TRTW(Time of Read To Write) ReadR}hWriteR}hs 5 clock+1 clock(Posted ReadPosted Write͎gpȂ Figure24 READ-To-WRITEQ)
	// Ԃ̂5clock 6clockɕύX(2008/08/13)
	always @(posedge clk) begin
		if (reset)
			TRTW <= 0;
		else if (c_state==READ)
			TRTW <= 4;
		else if (TRTW != 0)
			TRTW <= TRTW - 1;
	end
		
	// TWTR(Time of Write To Read) WriteR}hReadR}hs 6 clock(Write Wait+Twtr 7.5ns)
	always @(posedge clk) begin
		if (reset)
			TWTR <= 0;
		else if (c_state==WRIT)
			TWTR <= 4;
		else if (TWTR != 0)
			TWTR <= TWTR - 1;
	end
	
	// TRTR(Time of Read To Read) ReadR}hReadR}hs 2clock (ŏ4o[Xĝ߁j(3clocks)
	always @(posedge clk) begin
		if (reset)
			TRTR <= 0;
		else if (c_state==READ)
			TRTR <= 1;
		else if (TRTR != 0)
			TRTR <= TRTR - 1;
	end
	
	// TWTW(Time of Write To Write) WriteR}hWriteR}hs 2clock iŏ4o[Xĝ)
	always @(posedge clk) begin
		if (reset)
			TWTW <= 0;
		else if (c_state==WRIT)
			TWTW <= 1;
		else if (TWTW != 0)
			TWTW <= TWTW - 1;
	end
	
	// dON̎200usԁAckelowɂāADQ,DQSnCECs[_XɂB̂߂̃JE^
	always @(posedge clk1_16) begin
		if (reset) begin
			initial_count <= 0;
			initial_start <= 1'b0;
		end else if (initial_count != MAX_INITIAL_COUNT_VAL)
			initial_count <= initial_count + 1;
		else if (initial_count==MAX_INITIAL_COUNT_VAL)
			initial_start <= 1'b1; // CKE0ɂ鏉IADDR2 SDRAM̏X^[g
	end
	// init_start́A16NbNȂ̂ŁAclkŃTv
	always @(posedge clk) begin
		if (reset)
			initial_startx <= 1'b0;
		else
			initial_startx <= initial_start;
	end

	// cke_startclk0xœ
	always @(posedge clk) begin
		if (reset)
			cke_stat_clk0 <= 1'b0;
		else
			cke_stat_clk0 <= cke_stat;
	end
	
	// dON200usCKE1ɂ
	always @(posedge clkx, posedge reset) begin
		if (reset) begin
			cke_stat <= 1'b0;
			ddr2_cke <= 1'b0;
	   end else begin
		   if (initial_startx==1'b1)
			   cke_stat <= 1'b1;
			   
			ddr2_cke <= cke_stat;
		end
	end
	
	// dONCKE1ɂA400ns҂
	always @(posedge clk) begin
		if (reset) begin
			cke2palla_cnt <= 0;
			cke2palla_ena <= 1'b0;
		end else if (!cke2palla_ena && initial_startx && cke_stat_clk0) begin
		// dON200usoāACKE1ɂȂJEgX^[g
			if (cke2palla_cnt == CLK2PALLA_CNT_VAL)
				cke2palla_ena <= 1'b1;
			else
				cke2palla_cnt <= cke2palla_cnt + 1;
		end
	end
	
	// DLLZbgtOBDLLZbg1ɂȂ
	always @(posedge clk) begin
		if (reset)
			dll_reset_flag <= 1'b0;
		else if (c_init==mrs_dllrst_init && c_state==MRS) // DLLZbgflag=1
			dll_reset_flag <= 1'b1;
	end
	// DLLZbg200NbNJEg(16NbNŃJEg13JEgȂ̂ŁA16JEgƂj
	always @(posedge clk1_16) begin
		if (reset)
			dll_reset_cnt <= 0;
		else if (dll_reset_cnt[4]==1'b0 && dll_reset_flag==1'b1)
			dll_reset_cnt <= dll_reset_cnt + 1;
	end
	
	// dll_reset_cnt(4)clkŃTv
	always @(posedge clk) begin
		if (reset)
			dll_reset_end <= 1'b0;
		else
			dll_reset_end <= dll_reset_cnt[4];
	end
	
	// tbVpJE^
	always @(posedge clk1_16) begin
		if (reset)
			ref_count <= 0;
		else if (ref_count==MAX_REFRESH_COUNT) // tbV
			ref_count <= 0;
		else
			ref_count <= ref_count + 1;
	end

	always @(posedge clk) begin // clkŃTv
		if (reset)
			ref_then_by_now <= 1'b0;
		else
			ref_then_by_now <= ref_count[MAX_REFRESH_COUNT_LENGTH-1];
	end
	
	refreqsm REF_REQ_SM (
		.CLK(clk),
		.RESET(reset),
		.ref_state(ref_state),
		.ref_then_by_now(ref_then_by_now),
		.ref_req(ref_req)
	);
	assign ref_state = (c_state==REF) ? 1'b1 : 1'b0;
	
	// DDR2 SDRAMpXe[g}V
	always @(posedge clk) begin
		if (reset)
			c_init <= idle_init;
		else
			c_init <= n_init;
	end
	
	always @ * begin
		case (c_init)
			idle_init :
				if (initial_startx && cke_stat && cke2palla_ena)
					n_init <= pall1_init;
				else
					n_init <= idle_init;
			pall1_init : // ׂẴoNv`[W
				if (c_state==PALL)
					n_init <= emr2s_init;
				else
					n_init <= pall1_init;
			emr2s_init : // EMR(2)[hAI[0
				if (c_state==EMRS)
					n_init <= emr3s_init;
				else
					n_init <= emr2s_init;
			emr3s_init : // EMR(3)[hAI[0
				if (c_state==EMRS)
					n_init <= emrs_dllena_init;
				else
					n_init <= emr3s_init;
			emrs_dllena_init : // EMR[h
				if (c_state==EMRS)
					n_init <= mrs_dllrst_init;
				else
					n_init <= emrs_dllena_init;
			mrs_dllrst_init :
				if (c_state==MRS)
					n_init <= pall2_init;
				else
					n_init <= mrs_dllrst_init;
			pall2_init :
				if (c_state==PALL)
					n_init <= ref1_init;
				else
					n_init <= pall2_init;
			ref1_init :
				if (c_state==REF)
					n_init <= ref2_init;
				else
					n_init <= ref1_init;
			ref2_init :
				if (c_state==REF)
					n_init <= mrs_init;
				else
					n_init <= ref2_init;
			mrs_init :
				if (c_state==MRS)
					n_init <= emrs_ocd_def_init;
				else
					n_init <= mrs_init;
			emrs_ocd_def_init :
				if (c_state==EMRS)
					n_init <= emrs_ocd_exit_init;
				else
					n_init <= emrs_ocd_def_init;
			emrs_ocd_exit_init :
				if (c_state==EMRS)
					n_init <= wait_init_end;
				else
					n_init <= emrs_ocd_exit_init;
			wait_init_end :
				if (TMRD==0 && dll_reset_end==1'b1) // DLL̃ZbgI܂ő҂
					// n_init <= pattern_write_active;
					n_init <= init_end;
				else
					n_init <= wait_init_end;
			init_end :
				n_init <= init_end;
		endcase
	end
	
	// DDR2 SDRAM̃CXe[gE}V
	always @(posedge clk) begin
		if (reset)
			c_state <= NOP;
		else
			c_state <= n_state;
	end
	
	always @ * begin
		case (c_state)
			NOP : begin
				if (c_init != init_end) begin // DDR2 SDRAM̏
					case (c_init)
						pall1_init :
							n_state <= PALL;
						emr2s_init :
							if (TRP==0)
								n_state <= EMRS;
							else
								n_state <= NOP;
						emr3s_init :
							if (TMRD==0)
								n_state <= EMRS;
							else
								n_state <= NOP;
						emrs_dllena_init :
							if (TMRD==0)
								n_state <= EMRS;
							else
								n_state <= NOP;
						mrs_dllrst_init :
							if (TMRD==0)
								n_state <= MRS;
							else
								n_state <= NOP;
						pall2_init :
							if (TMRD==0)
								n_state <= PALL;
							else
								n_state <= NOP;
						ref1_init :
							if (TRP==0)
								n_state <= REF;
							else
								n_state <= NOP;
						ref2_init :
							if (TRFC==0)
								n_state <= REF;
							else
								n_state <= NOP;
						mrs_init :
							if (TRFC==0)
								n_state <= MRS;
							else
								n_state <= NOP;
						emrs_ocd_def_init :
							if (TMRD==0)
								n_state <= EMRS;
							else
								n_state <= NOP;
						emrs_ocd_exit_init :
							if (TMRD==0)
								n_state <= EMRS;
							else
								n_state <= NOP;
						default :
							n_state <= NOP;
					endcase
				end else begin // ʏ
					if (ref_req==1'b1) begin // tbV̎
						if (activate_bank==1'b1) begin // ANeBx[gꂽoN
							if (TRAS==0 && TPAW==0 && TPAR==0) // ACTR}hv`[W̃^C~O
								n_state <= PALL;
							else
								n_state <= NOP;
						end else
							if (TRP==0) // v`[WԂI烊tbVJn
								n_state <= REF;
							else
								n_state <= NOP;
					end else if (addr_fifo_empty==1'b0 && activate_bank==1'b0 && TRP==0 && TRFC==0 && TRC==0) // DDR2ւANZX̂ACTR}hsĂȂ̂ŁAACTR}h
						n_state <= ACT;
					else if (activate_bank==1'b1 && addr_fifo_empty==1'b0 && read_writex==1'b1) begin // ACTR}h𔭍sĂ̂Ń[h
						if (equal_active_bank || before_cmd_is_ACT==1'b1) begin // ROWbankAhXvAACT̎̃R}hł
							if (TWTR==0 && TRCD==0) // Write after READԂACT̑҂ԂNAAREAD
								n_state <= READ;
							else
								n_state <= NOP;
						end else begin // ROWbankAhXvȂ
							if (TRAS==0 && TPAW==0 && TPAR==0) // ACTR}hv`[W̃^C~O
								n_state <= PALL;
							else
								n_state <= NOP;
						end
					end else if (activate_bank==1'b1 && addr_fifo_empty==1'b0 && read_writex==1'b0) begin // ACTR}h𔭍sĂ̂ŃCg
						if (equal_active_bank || before_cmd_is_ACT==1'b1) begin // ROWbankAhXvAACT̎̃R}hł
							if (TRTW==0 && TRCD==0) // READ after WRITEԂACT̑҂ԂNAWRIT
								n_state <= WRIT;
							else
								n_state <= NOP;
						end else begin // ROWbankAhXvȂ
							if (TRAS==0 && TPAW==0 && TPAR==0) // ACTR}hv`[W̃^C~O
								n_state <= PALL;
							else
								n_state <= NOP;
						end
					end else
						n_state <= NOP;
				end
			end
			REF : n_state <= NOP;
			PALL : n_state <= NOP;
			MRS : n_state <= NOP;
			EMRS : n_state <= NOP;
			ACT : n_state <= NOP;
			READ : begin
				n_state <= NOP;
			end
			WRIT : begin
				n_state <= NOP;
			end
			default: n_state <= NOP;
		endcase
	end
	
	assign addr_fifo_rden = (c_init==init_end && !addr_fifo_empty && (c_state==READ || c_state==WRIT)) ? 1'b1 : 1'b0; // AhXFIFOǂݏoƂ́AIĂREADAWRITR}h𔭍s
	assign wrdata_fifo_rden_node = (c_state==WRIT || b_state==WRIT) ? 1'b1 : 1'b0; // DDR21WRIT2wrdata_fifõf[^ǂݏo
	
	assign wrdata_fifo_rden = wrdata_fifo_rden_node;
	// wrdata_fifo_rdeno͂ꂽƂwrdata_fifo_empty1ǂ`FbNAT[V
	// synthesis translate_off
	always @ (posedge clk) begin
		if (reset)
			;
		else
			if (wrdata_fifo_rden && wrdata_fifo_empty) begin // wrdata_fifoǂݏoƂempty -> Error
				$display("%m: at time %t ERROR : wrdata_fifo[hƂwrdata_fifo͋󂾂BDDR2 SDRAMRg[DDR2ɃCgꍇ́A1AhX2̃f[^ޕKv",$time);
				$stop;
			end
	end
	// synthesis translate_on
	
	always @ * begin // rasb, casb, web
		case (c_state)
			READ : begin  rasb_node <= 1'b1; casb_node <= 1'b0; web_node <= 1'b1;
			end
			WRIT : begin rasb_node <= 1'b1; casb_node <= 1'b0; web_node <= 1'b0;
			end
			ACT : begin rasb_node <= 1'b0; casb_node <= 1'b1; web_node <= 1'b1;
			end
			PALL : begin rasb_node <= 1'b0; casb_node <= 1'b1; web_node <= 1'b0;
			end
			MRS : begin rasb_node <= 1'b0; casb_node <= 1'b0; web_node <= 1'b0;
			end
			EMRS : begin rasb_node <= 1'b0; casb_node <= 1'b0; web_node <= 1'b0;
			end
			REF : begin rasb_node <= 1'b0; casb_node <= 1'b0; web_node <= 1'b1;
			end
			default : begin rasb_node <= 1'b1; casb_node <= 1'b1; web_node <= 1'b1;
			end
		endcase
	end
		
	always @(posedge clk) begin
		if (reset) begin
			rasb_node_1d <= 1'b1;
			casb_node_1d <= 1'b1;
			web_node_1d <= 1'b1;
		end else begin
			rasb_node_1d <= rasb_node;
			casb_node_1d <= casb_node;
			web_node_1d <= web_node;
		end
	end
	always @(posedge clkx) begin
		if (reset) begin
			rasb_node_2d <= 1'b1;
			casb_node_2d <= 1'b1;
			web_node_2d <= 1'b1;
		end else begin
			rasb_node_2d <= rasb_node_1d;
			casb_node_2d <= casb_node_1d;
			web_node_2d <= web_node_1d;
		end
	end
	always @(posedge clkx) begin
		if (reset) begin
			rasb_node_3d <= 1'b1;
			casb_node_3d <= 1'b1;
			web_node_3d <= 1'b1;
		end else begin
			rasb_node_3d <= rasb_node_2d;
			casb_node_3d <= casb_node_2d;
			web_node_3d <= web_node_2d;
		end
	end
			
	assign ddr2_rasb = rasb_node_3d;
	assign ddr2_casb = casb_node_3d;
	assign ddr2_web = web_node_3d;
	
	always @ * begin // DDR2 address
		case (c_state)
			READ : begin // I[gv`[W
				ddr2_addr_node <= {1'b0, 1'b0 , 1'b0, column_addr};
				bank_addr_node <= bank_addr;
			end
			WRIT : begin // I[gv`[W
				ddr2_addr_node <= {1'b0, 1'b0 , 1'b0, column_addr};
				bank_addr_node <= bank_addr;
			end
			ACT : begin
				ddr2_addr_node <= row_addr;
				bank_addr_node <= bank_addr;
			end
			PALL : begin
				ddr2_addr_node <= {2'bXX, 1'b1 ,10'bX};
				bank_addr_node <= 2'bX;
			end
			MRS : begin
				if (c_init==mrs_dllrst_init) // DLL reset
					ddr2_addr_node <= 13'b0_0101_0011_0010; // PD Mode = Fast Exit, Write Recovery = 3 (I[gv`[WR}h͎gpȂj, DLL Rest = Yes, TM = Normal, CAS# Latency = 3, Burst Type = Sequential, Burst Length = 4
				else // ȊO
					ddr2_addr_node <= 13'b0_0100_0011_0010; // PD Mode = Fast Exit, Write Recovery = 3 (I[gv`[WR}h͎gpȂj, DLL Rest = No, TM = Normal, CAS# Latency = 3, Burst Type = Sequential, Burst Length = 4
				bank_addr_node <= 2'b00;
			end
			EMRS : begin
				if (c_init==emr2s_init) begin // EMR(2)
					ddr2_addr_node <= 13'b0_0000_0000_0000;
					bank_addr_node <= 2'b10;
				end else if (c_init==emr3s_init) begin // EMR(3)
					ddr2_addr_node <= 13'b0_0000_0000_0000;
					bank_addr_node <= 2'b11;
				end else if (c_init==emrs_dllena_init || c_init==emrs_ocd_exit_init) begin // EMR, Output Disable, RDQS Disable, DQS# Enable, OCD = "000", RTT = 75?, Posted CAS = 0 (Posted CAS͎gpȂ), Output Drive Strength = Full Strength, DLL Enable
					ddr2_addr_node <= 13'b0_0000_0000_0100;
					bank_addr_node <= 2'b01;
				end else begin // EMR Output Enable, RDQS Disable, DQS# Enable, OCD = "111", RTT = 75&;, Posted CAS = 0 (Posted CAS͎gpȂ), Output Drive Strength = Full Strength, DLL Enable
					ddr2_addr_node <= 13'b0_0011_1000_0100;
					bank_addr_node <= 2'b01;
				end
			end
			default : begin // REF, NOP
				ddr2_addr_node <= {13{1'bx}};
				bank_addr_node <= 2'bxx;
			end
		endcase
	end
	always @(posedge clk) begin
		if (reset) begin
			ddr2_addr_node_1d <= 0;
			bank_addr_node_1d <= 0;
		end else begin
			ddr2_addr_node_1d <= ddr2_addr_node;
			bank_addr_node_1d <= bank_addr_node;
		end
	end
	always @(posedge clkx) begin
		if (reset) begin
			ddr2_addr_node_2d <= 0;
			bank_addr_node_2d <= 0;
		end else begin
			ddr2_addr_node_2d <= ddr2_addr_node_1d;
			bank_addr_node_2d <= bank_addr_node_1d;
		end
	end
	always @(posedge clkx) begin
		if (reset) begin
			ddr2_addr_node_3d <= 0;
			bank_addr_node_3d <= 0;
		end else begin
			ddr2_addr_node_3d <= ddr2_addr_node_2d;
			bank_addr_node_3d <= bank_addr_node_2d;
		end
	end
	assign ddr2_address = ddr2_addr_node_3d;
	assign ddr2_ba = bank_addr_node_3d;
	
	assign write_timing = (c_state==WRIT) ? 1'b1 : 1'b0;
	// assign read_timing = read_timing_node[CAS_LATENCY-1];
	assign read_timing = read_timing_node[CAS_LATENCY];
	assign read_timing_1b = read_timing_node[CAS_LATENCY-1];
	assign read_timing_2b = read_timing_node[CAS_LATENCY-2];
	
	always @(posedge clk) begin // read command̔s^C~OAcasb_node_3dȂǂgIOBɓȂȂ̂ł̑Onode_1d琶B
		if (reset)
			read_cmd_issue <= 1'b0;
		else if (casb_node_2d==1'b0 && rasb_node_2d==1'b1 && web_node_2d==1'b1)
			read_cmd_issue <= 1'b1;
		else
			read_cmd_issue <= 1'b0;
	end
	always @(posedge clk) begin // read_cmd_issue1NbNxM
		if (reset)
			read_cmd_issue_1d <= 1'b0;
		else
			read_cmd_issue_1d <= read_cmd_issue;
	end
	
	always @(posedge clk) begin : Read_Timig_Gen_Loop // read_timing𐶐Bread_data_moduleŃf[^DDR2o͂^C~O1NbNxB
		integer i;
		
		if (reset) begin
			read_timing_node <= 0;
		end else begin
			for (i=0; i<=CAS_LATENCY; i=i+1) begin
				if (i==0) begin
					if (read_cmd_issue || read_cmd_issue_1d) // readR}hsꂽƂ1NbNADDR4o[Xgł邽
						read_timing_node[0] <= 1'b1;
					else
						read_timing_node[0] <= 1'b0;
				end else
					read_timing_node[i] <= read_timing_node[i-1];
			end
		end
	end
	
	always @(posedge clk) begin
		if (reset) begin
			b_state <= NOP;
			b2_state <= NOP;
		end else begin
			b_state <= c_state;
			b2_state <= b_state;
		end
	end
	assign burst_read = (c_init==init_end && c_state==READ && b_state==READ) ? 1'b1 : 1'b0; // burst READ̎1
	// burst WRITEȂ
	always @(posedge clk) begin
		if (reset)
			dqs_reset <= 1'b0;
		else begin
			if (c_state==WRIT && b2_state!=WRIT)
				dqs_reset <= 1'b1;
			else
				dqs_reset <= 1'b0;
		end
	end
	
	always @(posedge clk) begin
		if (reset)
			cs_dets <= idle_dets;
		else
			cs_dets <= ns_dets;
	end
	always @ * begin
		case (cs_dets)
			idle_dets : begin
				dqs_enable <= 1'b0;
				if (c_state==WRIT)
					ns_dets <= write_dets;
				else
					ns_dets <= idle_dets;
			end
			write_dets : begin
				dqs_enable <= 1'b1;
				ns_dets <= write_wait;
			end
			write_wait : begin // DDR24o[XgɂȂ̂1wait
				dqs_enable <= 1'b1;
				if (c_state==WRIT)
					ns_dets <= write_dets;
				else
					ns_dets <= idle_dets;
			end
		endcase
	end
	
	always @(posedge clk) begin 
		if (reset) begin
			initialize_end <= 1'b0;
		end else begin
			if (c_init==init_end)
				initialize_end <= 1'b1;
		end
	end

	// DDR2_ODT
`ifdef DDR2_ODT_ENABLE
	always @(posedge clkx) begin
		if (reset)
			cs_odt <= IDLE_ODT;
		else
			cs_odt <= ns_odt;
	end
	
	always @ * begin
		case (cs_odt)
			IDLE_ODT : begin
				odt_node <= 1'b0;
				if (write_timing)
					ns_odt <= WRITE_ACTIVE;
				else
					ns_odt <= IDLE_ODT;
			end
			WRITE_ACTIVE : begin
				odt_node <= 1'b1;
				ns_odt <= WRITE_TEST; // write_timing܂1̂܂܂eXg
			end
			WRITE_TEST : begin
				odt_node <= 1'b1;
				if (write_timing)
					ns_odt <= WRITE_ACTIVE;
				else
					ns_odt <= WRITE_HOLDOFF1;
			end
			WRITE_HOLDOFF1: begin
				odt_node <= 1'b1;
				ns_odt <= IDLE_ODT;
			end
		endcase
	end
	
	always @(posedge clkx) begin
		if (reset)
			odt_node_1d <= 1'b0;
		else
			odt_node_1d <= odt_node;
	end
	assign ddr2_odt = odt_node_1d;
`else
	assign ddr2_odt = 1'b0;
`endif
		
// synthesis translate_off
	reg [20*8:1] MAIN_STATE, INIT_STATE, STATE_DETS, ODT_STATE; 
	
	always @(c_state) begin
		case (c_state)
			NOP:		MAIN_STATE <= "NOP";
			ACT:		MAIN_STATE <= "ACT";
			READ:		MAIN_STATE <= "READ";
			WRIT:		MAIN_STATE <= "WRIT";
            PALL:		MAIN_STATE <= "PALL";
			MRS:		MAIN_STATE <= "MRS";
			EMRS:		MAIN_STATE <= "EMRS";
			default:	MAIN_STATE <= "REF"; 
		endcase
	end
	
	always @(c_init) begin
		case (c_init)
			idle_init:			INIT_STATE <= "IDLE_INIT";
			pall1_init:			INIT_STATE <= "PALL1_INIT";
			emr2s_init:			INIT_STATE <= "EMR2S_INIT";
			emr3s_init:			INIT_STATE <= "EMR3S_INIT";
			emrs_dllena_init:	INIT_STATE <= "EMRS_DLLENA_INIT";
			mrs_dllrst_init:	INIT_STATE <= "MRS_DLLRST_INIT";
			pall2_init:			INIT_STATE <= "PALL2_INIT";
			ref1_init:			INIT_STATE <= "REF1_INIT";
			ref2_init:			INIT_STATE <= "REF2_INIT";
			mrs_init:			INIT_STATE <= "MRS_INIT";
			emrs_ocd_def_init:	INIT_STATE <= "EMRS_OCD_DEF_INIT";
			emrs_ocd_exit_init:	INIT_STATE <= "EMRS_OCD_EXIT_INIT";
			wait_init_end:		INIT_STATE <= "WAIT_INIT_END";
			default:			INIT_STATE <= "INIT_END";
		endcase
	end
	
	always @(cs_dets) begin
		case(cs_dets)
			idle_dets:	STATE_DETS <= "IDLE_DETS";
			write_dets:	STATE_DETS <= "WRITE_DETS";
			default:	STATE_DETS <= "WRITE_WAIT";
		endcase
	end
	
	always @(cs_odt) begin
		case (cs_odt)
			IDLE_ODT:		ODT_STATE <= "IDLE_ODT";
			WRITE_ACTIVE:	ODT_STATE <= "WRITE_ACTIVE";
			WRITE_TEST :	ODT_STATE <= "WRITE_TEST";
			default:		ODT_STATE <= "WRITE_HOLDOFF1";
		endcase
	end
// synthesis translate_on
endmodule
		