// addr_fifo.v
// AhXێĂFIFOBdoutnext_douto͂Aempty=0, almost_empty=1̎́AdoutL
// empty=0, almost_empty=0̎doutnext_doutƂLB邱ƂɂāAdoutnext_doutrł
// o[Xgł邩ǂB
// 64DepthFIFOō邱ƂɂBRAM64X1Dgp
// Read_WriteV݁Arw_out, next_rw_outV

// 2008/03/07 : Ver. 1.1 : wp, rpƉZ鐔̃rbg𐧌,@rbg̐ȂƓ-̉Z鎞ɕg32rbgōs邽߂fullo͂Ȃ

`default_nettype none
`timescale 1ns / 1ps

module addr_fifo(clk, reset, din, read_write, wr_en, rd_en, dout, rw_out, full, empty, next_dout, next_rw_out, almost_empty, almost_full);
	`include "./ddr2_cont_parameters.vh"

	input clk, reset;
	input [USER_INPUT_ADDRESS_WIDTH-1:0] din;
	input read_write;
	input wr_en, rd_en;
	output [USER_INPUT_ADDRESS_WIDTH-1:0] dout;
	output rw_out;
	output full, empty;
	output [USER_INPUT_ADDRESS_WIDTH-1:0] next_dout;
	output next_rw_out, almost_empty, almost_full;

	wire clk, reset;
	wire [USER_INPUT_ADDRESS_WIDTH-1:0] din;
	wire read_write;
	wire wr_en, rd_en;
		
	wire [USER_INPUT_ADDRESS_WIDTH-1:0] dout;
	wire rw_out;
	wire full;
	wire empty;
	wire [USER_INPUT_ADDRESS_WIDTH-1:0] next_dout;
	wire next_rw_out, almost_empty, almost_full;
	
	wire we;
	reg [3:0] wp, rp;
	reg [USER_INPUT_ADDRESS_WIDTH-1:0] outff1, outff2;
	wire [USER_INPUT_ADDRESS_WIDTH-1:0] out_sig;
	wire fifo_full;
	wire fifo_empty;
	reg rwff1, rwff2;
	wire out_rw;
	wire inner_rd_en;
	reg outff1_flag, outff2_flag;
	wire wr_en_node;
	
	assign 
	// synthesis translate_off
			#1
	// synthesis translate_on
				wr_en_node =wr_en;

	generate
	genvar i;
		for (i=USER_INPUT_ADDRESS_WIDTH-1; i>=0; i=i-1) begin: ADDR_RAM
			RAM16X1D #(
				.INIT(16'h0000) // Initial contents of RAM
			) RAM16_INST (
				.DPO(out_sig[i]),
				.SPO(),
				.A0(wp[0]),
				.A1(wp[1]),
				.A2(wp[2]),
				.A3(wp[3]),
				.D(din[i]),
				.DPRA0(rp[0]),
				.DPRA1(rp[1]),
				.DPRA2(rp[2]),
				.DPRA3(rp[3]),
				.WCLK(clk),
				.WE(we)
			);
		end
	endgenerate
	assign we = wr_en_node & ~fifo_full;
	
	RAM16X1D #(
		.INIT(16'h0000) // Initial contents of RAM
	) Inst_FIFO_WR (
		.DPO(out_rw),
		.SPO(),
		.A0(wp[0]),
		.A1(wp[1]),
		.A2(wp[2]),
		.A3(wp[3]),
		.D(read_write),
		.DPRA0(rp[0]),
		.DPRA1(rp[1]),
		.DPRA2(rp[2]),
		.DPRA3(rp[3]),
		.WCLK(clk),
		.WE(we)
	);
	
	always @(posedge reset, posedge clk) begin
		if (reset==1'b1)
			wp <= 0;
		else if (wr_en_node==1'b1 && fifo_full==1'b0) // wr_en1ŁAFIFOtłȂƂɏ
			wp <= wp + 4'h1;
	end
	always @(posedge reset, posedge clk) begin
		if (reset==1'b1)
			rp <= 0;
		else if (inner_rd_en==1'b1 && fifo_empty==1'b0) // rd_en1ŁAFIFOemptyłȂɓǂݏo
			rp <= rp + 4'h1;
	end
	
	assign fifo_full = (rp-4'h1==wp) ? 1'b1: 1'b0;
	assign full = fifo_full;
	assign almost_full = (rp-4'h2==wp) ? 1'b1: 1'b0;
	assign fifo_empty = (rp==wp) ? 1'b1: 1'b0;
	
	always @(posedge reset, posedge clk) begin // outff1
		if (reset==1'b1) begin
			outff1 <= 0;
			rwff1 <= 1'b0;
		end else if (fifo_empty==1'b0 && (~(rd_en==1'b0 && outff1_flag==1'b1 && outff2_flag==1'b1))) begin
			// FIFOłȂAoutff1,outff2ςœǂݏoȂȊOoutff1FIFO̓eǂݏoB
			outff1 <= out_sig;
			rwff1 <= out_rw;
		end
	end
	
	assign inner_rd_en = (fifo_empty==1'b0 && (~(rd_en==1'b0 && outff1_flag==1'b1 && outff2_flag==1'b1))) ? 1'b1 : 1'b0;
	
	always @(posedge reset, posedge clk) begin // outff2
		if (reset==1'b1) begin
			outff2 <= 0;
			rwff2 <= 1'b0;
		end else if (outff1_flag==1'b1 && (outff2_flag==1'b0 || (outff2_flag==1'b1 && rd_en==1'b1))) begin
			// outff1Ƀf[^āAoutff2Ƀf[^ĂȂAĂĂǂݏoƂɃf[^
			outff2 <= outff1;
			rwff2 <= rwff1;
		end
	end
	
	always @(posedge reset, posedge clk) begin // outff1_flag
		if (reset==1'b1)
			outff1_flag <= 1'b0;
		else if (inner_rd_en == 1'b1)
			outff1_flag <= 1'b1;
		else if (outff2_flag==1'b0 || rd_en==1'b1) //inner_rd_en0Ȃ̂ŁAoutff2󂩁AǂݏoꂽoutffVtgꂽ̂0
			outff1_flag <= 1'b0;
	end
	
	always @(posedge reset, posedge clk) begin // outff2_flag
		if (reset==1'b1)
			outff2_flag <= 1'b0;
		else if (outff1_flag==1'b1 && (outff2_flag==1'b0 || (outff2_flag==1'b1 && rd_en==1'b1)))
			// outff1Ƀf[^āAoutff2Ƀf[^ĂȂAĂĂǂݏoƂɃf[^
			outff2_flag <= 1'b1;
		else if (outff1_flag==1'b0 && rd_en==1'b1) // ̃f[^ȂāAf[^ǂݏoꂽ0
			outff2_flag <= 1'b0;
	end
	
	assign empty = ~outff2_flag;
	assign almost_empty = (outff2_flag==1'b0 || (outff2_flag==1'b1 && outff1_flag==1'b0)) ? 1'b1 : 1'b0;
	assign next_dout = outff1;
	assign dout = outff2;
	assign next_rw_out = rwff1;
	assign rw_out = rwff2;
	
	// AT[V
	// synthesis translate_off
	always @ (posedge clk) begin
		if (reset)
			;
		else
			if (rd_en && empty) begin
				$display("%m: at time %t ERROR : FIFOȂ̂Ƀ[h",$time);
				$stop;
			end
			if (wr_en && full) begin 
				$display("%m: at time %t ERROR : FIFOtȂ̂ɃCg",$time);
				$stop;
			end
	end
	// synthesis translate_on
	
endmodule
