// DCM module
// 50MHz͂āADDR2_SDRAMpclkclk90𐶐BDDR2 SDRAMւ̏o̓NbNADDR2_CLKDDR2_CLKB

`default_nettype none
`timescale 1ns / 1ps

(* KEEP_HIERARCHY = "TRUE" *)module dcm_DDR2_clk (sysclk, reset, clk_sdram, dcm_locked_out);
	`include "./ddr2_cont_parameters.vh"
	input	wire	sysclk;
	input	wire	reset;
	output	wire	clk_sdram;
	output	wire	dcm_locked_out;
	
	wire clk_bufg, clk_node, dcm1_locked;
	wire clk_sdram_node, clk_sdram_bufg;
		
	DCM dcm_DDR2_clk_dcm (
		.CLKIN(sysclk),
		.CLKFB(clk_bufg),
		.DSSEN(1'b0),
		.PSINCDEC(1'b0),
		.PSEN(1'b0),
		.PSCLK(1'b0),
		.RST(1'b0), 	// OiDCMbN܂ŃZbg
		.CLK0(clk_node),
		.CLK90(),
		.CLK180(),
		.CLK270(),
		.CLK2X(),
		.CLK2X180(),
		.CLKDV(),
		.CLKFX(clk_sdram_node),
		.CLKFX180(),
		.LOCKED(dcm1_locked),
		.PSDONE(),
		.STATUS()
	);
	defparam dcm_DDR2_clk_dcm.CLKIN_PERIOD = 20.0;
	defparam dcm_DDR2_clk_dcm.DLL_FREQUENCY_MODE = "LOW";
	defparam dcm_DDR2_clk_dcm.DUTY_CYCLE_CORRECTION = "TRUE";
	defparam dcm_DDR2_clk_dcm.CLKDV_DIVIDE = 16.0;
	defparam dcm_DDR2_clk_dcm.PHASE_SHIFT = 0;
	defparam dcm_DDR2_clk_dcm.CLKOUT_PHASE_SHIFT = "NONE";
	defparam dcm_DDR2_clk_dcm.STARTUP_WAIT = "FALSE";
	defparam dcm_DDR2_clk_dcm.CLKFX_DIVIDE = 1;
	defparam dcm_DDR2_clk_dcm.CLKFX_MULTIPLY = 3;
	// defparam dcm_DDR2_clk_dcm.FACTORY_JF = 16'hFFFF;
	
	BUFG CLK_BUFG_INST (
		.I(clk_node),
		.O(clk_bufg)
	);
	
	BUFG CLK200_BUFG_INST (
		.I(clk_sdram_node),
		.O(clk_sdram_bufg)
	);
	assign clk_sdram = clk_sdram_bufg;	
	assign dcm_locked_out = dcm1_locked;
endmodule
