// DDR2 SDRAM Controller for test
// ȂƂnLED0(D1)_A[hG[̂ƂnLED1(D2)_

// 2008/03/22 : Ver. 1.1 : sd_ck_fb
// 2008/08/09 : DDR2 SDRAMpɏ

`default_nettype none
`timescale 1ns / 1ps

module DDR2_burst_test(SYS_CLK, SYS_RST, LED, ddr2_clk, ddr2_clkb, ddr2_cke, ddr2_dqs, ddr2_dqs_n, ddr2_dq, ddr2_csb, ddr2_rasb, ddr2_casb, ddr2_web, ddr2_dm, ddr2_ba, ddr2_address, ddr2_odt, sd_loop_in, sd_loop_out);

`include "./ddr2_cont_parameters.vh"

	input SYS_CLK;
	input SYS_RST;
	output [3:0] LED;
	
	output [QUANTITY_OF_CLK_OUTPUT-1 : 0] ddr2_clk;
	output [QUANTITY_OF_CLK_OUTPUT-1 : 0] ddr2_clkb;
	output ddr2_cke;
	inout [DDR2_DQS_DM_WIDTH-1 : 0] ddr2_dqs;
	inout [DDR2_DQS_DM_WIDTH-1 : 0] ddr2_dqs_n;
	inout [DDR2_DATA_WIDTH-1 : 0] ddr2_dq;
	output ddr2_csb;
	output ddr2_rasb;
	output ddr2_casb;
	output ddr2_web;
	output [DDR2_DQS_DM_WIDTH-1 : 0] ddr2_dm;
	output [1:0] ddr2_ba;
	output [DDR2_ADDRESS_WIDTH-1 : 0] ddr2_address;
	output ddr2_odt;
	input	sd_loop_in;
	output	sd_loop_out;
	
	wire SYS_CLK;
	wire SYS_RST;
	wire [3:0] LED;
	
	wire [QUANTITY_OF_CLK_OUTPUT-1 : 0] ddr2_clk;
	wire [QUANTITY_OF_CLK_OUTPUT-1 : 0] ddr2_clkb;
	wire ddr2_cke;
	wire [DDR2_DQS_DM_WIDTH-1 : 0] ddr2_dqs;
	wire [DDR2_DQS_DM_WIDTH-1 : 0] ddr2_dqs_n;
	wire [DDR2_DATA_WIDTH-1 : 0] ddr2_dq;
	wire ddr2_csb;
	wire ddr2_rasb;
	wire ddr2_casb;
	wire ddr2_web;
	wire [DDR2_DQS_DM_WIDTH-1 : 0] ddr2_dm;
	wire [1:0] ddr2_ba;
	wire [DDR2_ADDRESS_WIDTH-1 : 0] ddr2_address;
	wire ddr2_odt;
	wire	sd_loop_in;
	wire	sd_loop_out;
	
	wire logic0, logic1;
	reg [INTERFACE_DATA_WIDTH-1 : 0] input_data;
	wire [INTERFACE_MASK_WIDTH-1 : 0] input_mask;
	wire read_write;
	reg [USER_INPUT_ADDRESS_WIDTH-1 : 0] input_address;
	wire addr_fifo_wren;
	wire wrdata_fifo_wren;
	wire addr_fifo_full;
	wire wrdata_fifo_full;
	wire rddata_valid;
	wire initialize_end;
	wire [15:0] DDR_write_data, DDR_read_data;
	wire sw_ena;
	wire read_ddr_cont;
	wire [INTERFACE_DATA_WIDTH-1 : 0] output_data;
	wire read_write_node, addr_fifo_wren_node, wrdata_fifo_wren_node;
	wire clk;
	reg [6:0] cs, ns;
	reg [7:0] burst_length, write_counter, read_counter;
	reg read_error;
	reg [USER_INPUT_ADDRESS_WIDTH-1 : 0]  temp_in_addr;
	reg [INTERFACE_DATA_WIDTH-1 : 0] expected_read_data;
	wire dcm_locked_out;
	wire reset;
	reg [3:0] nLED;
	wire clk_sdram, dcm_locked_200;
	
	parameter 	IDLE =			7'b0000001,
				ADDRESS_LOAD =	7'b0000010,
				DATA_WRITE1 =	7'b0000100,
				DATA_WRITE2 =	7'b0001000,
				DATA_READ1 =	7'b0010000,
				DATA_READ2 =	7'b0100000,
				ERROR_DET = 	7'b1000000;
				
	parameter LIMIT_OF_BURST_LENGTH = 8'd16;
	
	assign logic0 = 1'b0;
	assign logic1 = 1'b1;
	assign reset = SYS_RST | ~dcm_locked_out;
	assign LED = ~nLED;
	
	dcm_DDR2_clk dcm_DDR2_clk_inst(
		.sysclk(SYS_CLK),
		.reset(reset),
		.clk_sdram(clk_sdram),
		.dcm_locked_out(dcm_locked_200)
	);
	
	ddr2_sdram_cont ddr2_sdram_cont_inst (
		.sysclk(clk_sdram),
		.clk_out(clk),
		.reset(SYS_RST),
		.input_data(input_data),
		.input_mask(input_mask),
		.read_write(read_write),
		.output_data(output_data),
		.input_address(input_address),
		.addr_fifo_wren(addr_fifo_wren),
		.wrdata_fifo_wren(wrdata_fifo_wren),
		.addr_fifo_full(addr_fifo_full),
		.wrdata_fifo_full(wrdata_fifo_full),
		.rddata_valid(rddata_valid),
		.initialize_end(initialize_end),
		.dcm_locked_in(dcm_locked_200),
		.dcm_locked_out(dcm_locked_out),
		.ddr2_clk(ddr2_clk),
		.ddr2_clkb(ddr2_clkb),
		.ddr2_cke(ddr2_cke),
		.ddr2_dqs(ddr2_dqs),
		.ddr2_dqs_n(ddr2_dqs_n),
		.ddr2_dq(ddr2_dq),
		.ddr2_csb(ddr2_csb),
		.ddr2_rasb(ddr2_rasb),
		.ddr2_casb(ddr2_casb),
		.ddr2_web(ddr2_web),
		.ddr2_dm(ddr2_dm),
		.ddr2_ba(ddr2_ba),
		.ddr2_address(ddr2_address),
		.ddr2_odt(ddr2_odt),
		.sd_loop_in(sd_loop_in),
		.sd_loop_out(sd_loop_out)
	);
	
	assign input_mask = 0;
	
	always @(posedge clk, posedge reset) begin
		if (reset)
			input_data <= 0;
		else
			if ((cs==DATA_WRITE1 || cs==DATA_WRITE2) && !addr_fifo_full && !wrdata_fifo_full) 
				input_data <= input_data + 1;
	end
	
	// DDR SDRAMRg[o[Xgǂݏ`FbNpXe[g}V
	always @(posedge clk, posedge reset) begin
		if (reset)
			cs <= IDLE;
		else
			cs <= ns;
	end
	always @* begin
		nLED[3:2] <= 2'b11;
		case (cs)
			IDLE : begin
				nLED[0] <= 1'b0; nLED[1] <= 1'b1;
				if (read_error) // DATA_READŃG[oԂɍȂꍇ邽
					ns <= ERROR_DET;
				else if (initialize_end)
					ns <= ADDRESS_LOAD;
				else
					ns <= IDLE;
			end
			ADDRESS_LOAD : begin
				nLED[0] <= 1'b0; nLED[1] <= 1'b1;
				ns <= DATA_WRITE1;
			end
			DATA_WRITE1 : begin
				nLED[0] <= 1'b0; nLED[1] <= 1'b1;
				if (read_error) // DATA_READŃG[oԂɍȂꍇ邽
					ns <= ERROR_DET;
				else if (!addr_fifo_full && !wrdata_fifo_full)
					ns <= DATA_WRITE2;
				else
					ns <= DATA_WRITE1;
			end
			DATA_WRITE2 : begin
				nLED[0] <= 1'b0; nLED[1] <= 1'b1;
				if (read_error) // DATA_READŃG[oԂɍȂꍇ邽
					ns <= ERROR_DET;
				else if (write_counter==1) begin // WRITEI
					if (!addr_fifo_full && !wrdata_fifo_full)
						ns <= DATA_READ1;
					else
						ns <= DATA_WRITE2;
				end else begin
					if (!addr_fifo_full && !wrdata_fifo_full)
						ns <= DATA_WRITE1;
					else
						ns <= DATA_WRITE2;
				end
			end
			DATA_READ1 : begin
				nLED[0] <= 1'b0; nLED[1] <= 1'b1;
				if (read_error)
					ns <= ERROR_DET;
				else if (!addr_fifo_full)
					ns <= DATA_READ2;
				else
					ns <= DATA_READ1;
			end
			DATA_READ2 : begin
				nLED[0] <= 1'b0; nLED[1] <= 1'b1;
				if (read_error)
					ns <= ERROR_DET;
				else if (read_counter==1) begin
					if (!addr_fifo_full)
						ns <= ADDRESS_LOAD;
					else
						ns <= DATA_READ2;
				end else
					ns <= DATA_READ1;
			end
			ERROR_DET : begin
				nLED[0] <= 1'b1; nLED[1] <= 1'b0;
				ns <= ERROR_DET;
				// pragma translate_off
					$display("[hG[o");
					#10 $stop;
				// pragma translate_on
			end
		endcase
	end
	
	// 2009/06/25 AhXrbĝlfsr22lfsr23ɕύX܂
	// lfsr22, lfsr8, get_next_random_address function͂Verilog HDLR[hpĂĂ܂B
	// http://japanese.sugawara-systems.com/opencores/VPI/cpu.htm#R4
	function [22:0] lfsr23 (input [22:0] data);
		reg lsb;
		//Mn^bvĺAȉ璸܂B
		//http://www.madlabo.com/mad/edat/mathematic/M/index.htm#SEC5
		//400010
		begin
			 lsb=data[22] ^ data[4];
			 lfsr23={data[21:0],lsb};//MSB ɃVtg
		end
	endfunction

	function [7:0] lfsr8 (input [7:0] data);
		reg lsb;
		//CD polynominal
		//1001_1101
		begin
			 lsb=data[7] ^ data[4]^data[3] ^data[2]^data[0];
			 lfsr8={data[6:0],lsb};//MSB ɃVtg
		end
	endfunction
	
	//24rbg̃_uȂ_AhX𓾂@
	//4bytes boundary 0́As
	function [24:0] get_next_random_address ( input [24:0] old_address);
		  //assert( !old_address);
		  get_next_random_address=lfsr23(old_address >>2) <<2;
	endfunction

	// input_address
	always @(posedge clk, posedge reset) begin
		if (reset) begin
			input_address <= 4;
			temp_in_addr <= 4;
		end else begin
			if (cs == ADDRESS_LOAD) begin
				input_address <= get_next_random_address(temp_in_addr);
				temp_in_addr <= get_next_random_address(temp_in_addr);
			end else if (cs==DATA_WRITE1 || cs==DATA_WRITE2) begin
				if (write_counter==8'h01 && !addr_fifo_full && !wrdata_fifo_full)
					input_address <= temp_in_addr;
				else if (!addr_fifo_full && !wrdata_fifo_full)
					input_address <= input_address + 2;
			end else if (cs==DATA_READ1 || cs==DATA_READ2) begin
				if (read_counter!=8'h01 && !addr_fifo_full)
					input_address <= input_address + 2;
			end
		end
	end
	
	// burst length
	always @(posedge clk, posedge reset) begin
		if (reset) begin
			burst_length <= 1;
			write_counter <= 1;
			read_counter <= 1;
		end else begin
			if (cs == ADDRESS_LOAD) begin
				if (lfsr8(burst_length) > LIMIT_OF_BURST_LENGTH) begin
					burst_length <= 1;
					write_counter <= 1;
					read_counter <= 1;
				end else begin
					burst_length <= lfsr8(burst_length);
					write_counter <= lfsr8(burst_length);
					read_counter <= lfsr8(burst_length);
				end
			end else if (cs==DATA_WRITE2 && !addr_fifo_full && !wrdata_fifo_full)
				write_counter <= write_counter - 1;
			else if (cs==DATA_READ2 && !addr_fifo_full)
				read_counter <= read_counter - 1;
		end
	end
	
	// [hf[^r邽߂̃WX^i[hf[^̊Ғlj
	always @(posedge clk, posedge reset) begin
		if (reset)
			expected_read_data <= 0;
		else
			if (rddata_valid)
				expected_read_data <= expected_read_data + 1;
	end
	
	// [hf[^̊ҒlƎۂ̃[hf[^r
	always @(posedge clk, posedge reset) begin
		if (reset)
			read_error <= 1'b0;
		else begin
			// if (rddata_valid && output_data==32'h0000_0020) // G[`FbNpA킴ƃG[o
				// read_error <= 1'b1;
			if (rddata_valid && (output_data!=expected_read_data))
				read_error <= 1'b1;
			else
				read_error <= 1'b0;
		end
	end
	assign read_write_node = (cs==DATA_WRITE1 || cs==DATA_WRITE2) ? 1'b0 : 1'b1;
	assign addr_fifo_wren_node = ((cs==DATA_WRITE1 && !addr_fifo_full && !wrdata_fifo_full) || (cs==DATA_READ1 && !addr_fifo_full)) ? 1'b1 : 1'b0;
	assign wrdata_fifo_wren_node = ((cs==DATA_WRITE1 || cs==DATA_WRITE2) && !addr_fifo_full && !wrdata_fifo_full) ? 1'b1 : 1'b0;
			
	assign
	// pragma translate_off
			#1
	// pragma traslate on
				read_write = read_write_node;
	assign
	// pragma translate_off
			#1
	// pragma traslate on
				addr_fifo_wren = addr_fifo_wren_node;
	assign
	// pragma translate_off
			#1
	// pragma traslate on
				wrdata_fifo_wren = wrdata_fifo_wren_node;

	// synthesis translate_off
	reg [20*8:1] STATE; 
	
	always @(cs) begin
		case (cs)
			IDLE:			STATE <= "IDLE";
			ADDRESS_LOAD:	STATE <= "ADDRESS_LOAD";
			DATA_WRITE1:		STATE <= "DATA_WRITE1";
			DATA_WRITE2:		STATE <= "DATA_WRITE2";
			DATA_READ1:		STATE <= "DATA_READ1";
			DATA_READ2:		STATE <= "DATA_READ2";
 			default:	STATE <= "ERROR_DET"; 
		endcase
	end
// synthesis translate_on
endmodule	

